import { Inject, Injectable } from '@nestjs/common';
import { PrimeLogger, TxType } from 'src/framework';
import { UserCompanyRepository, UserCompanyService } from 'src/licitaapp';
import { Company } from 'src/licitaapp/domain';
import { UserMinimalTO } from 'src/licitaapp/domain/dto/user.minimal.to';


@Injectable()
export class UserCompanyServiceImpl implements UserCompanyService {
    private readonly LOGGER = new PrimeLogger(UserCompanyServiceImpl.name);
    constructor(
        @Inject('UserCompanyRepository') private readonly userCompanyRepository: UserCompanyRepository
    ) {}
    async countUserByCompany(companyId: number): Promise<number> {
        this.LOGGER.log(`Counting users by company: ${companyId}`);
        return await this.userCompanyRepository.countUserByCompany(companyId);
    }
    async getInfoUserCompany(companyId: number): Promise<UserMinimalTO[]> {
        this.LOGGER.log(`Getting info user company for company: ${companyId}`);
        return await this.userCompanyRepository.getInfoUserCompany(companyId);
    }
    async getUserIdsWithActiveCompany(): Promise<number[]> {
        this.LOGGER.log('Getting user ids with active company');
        return await this.userCompanyRepository.getUserIdsWithActiveCompany();
    }
    async saveUserCompany(userId: number, companyId: number, tx?: TxType): Promise<boolean> {
        this.LOGGER.log(`Saving user company: ${userId} - ${companyId}`);
        return await this.userCompanyRepository.save(userId, companyId, tx);
    }
    async findCompaniesByUserId(userId: number): Promise<Company[]> {
        this.LOGGER.log(`Finding companies by user: ${userId}`);
        return await this.userCompanyRepository.findCompaniesByUserId(userId);
    }
    async paginationByUser(userId: number, page: number, pageSize: number): Promise<Company[]> {
        this.LOGGER.log(`paginationByUser user ${userId} page ${page} pageSize ${pageSize}`);
        return await this.userCompanyRepository.paginationByUser(userId, page, pageSize);
    }
    async deleteByUserCompany(userId: number, companyId: number): Promise<void> {
        this.LOGGER.log(`deleteByUserCompany userId ${userId} companyId ${companyId}`);
        await this.userCompanyRepository.deleteByUserCompany(userId, companyId);
    }
}
