import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule, GeoModule, NotificationModule, UserModule, UserRequestModule } from 'src/framework';
import { TendersController } from '../../controllers/tender/tender.controller';
import { TenderServiceImpl } from '../../service/tender-service-impl/tender-service-impl';
import { TenderRepositoryImpl } from '../../repository/tender-repository-impl/tender-repository-impl';
import { MatchWordsServiceImpl } from '../../service/match-words-service-impl/match-words-service-impl';
import { UserCompanyTenderModule } from '../user-company-tender/user-company-tender.module';
import { HistoryTenderModule } from '../history-tender/history-tender.module';
import { CompanyModule } from '../company/company.module';
import { MercadoPublicoController } from '../../controllers/mercado-publico/mercado-publico.controller';
import { TenderFetcherServiceImpl } from '../../service/tender-fetcher-service-impl/tender-fetcher-service-impl';
import { MercadoPublicoRepository } from 'src/licitaapp/application/mercado-publico/mp.repository';
import { HttpModule } from '@nestjs/axios';
import { NotificationRecordModule } from 'src/framework/infrastructure/module/notification-record/notification-record.module';
import { KeywordModule } from '../keyword/keyword.module';
import { ApplicationLogModule } from '../application-log/application-log.module';
import { CompanyController } from '../../controllers';
import { MercadoPublicoModule } from 'src/licitaapp/application';

@Module({
  imports: [forwardRef(() => DrizzleModule), CompanyModule, UserCompanyTenderModule,HttpModule,
    KeywordModule, 
    MercadoPublicoModule,
    ApplicationLogModule,
    forwardRef(() =>UserRequestModule),
    forwardRef(() =>UserModule),
    HistoryTenderModule, forwardRef(() =>NotificationModule), NotificationRecordModule, forwardRef(() =>GeoModule)],
  controllers: [TendersController, MercadoPublicoController, CompanyController],
  providers: [
    {
      provide: 'TenderService',
      useClass: TenderServiceImpl,
    },
    {
      provide: 'TenderRepository',
      useClass: TenderRepositoryImpl,
    },
    {
      provide: 'MatchWordsService',
      useClass: MatchWordsServiceImpl,
    },
    {
      provide: 'TenderFetcherService',
      useClass: TenderFetcherServiceImpl,
    },
  ],
  exports: [
        'TenderService',
        'TenderRepository',
        'MatchWordsService',
        'TenderFetcherService',
    ],
})
export class TenderModule {}
