import { forwardRef, Module } from '@nestjs/common';
import { HistoryTenderServiceImpl } from '../../service/history-tender-service-impl/history-tender-service-impl';
import { HistoryTenderRepositoryImpl } from '../../repository/history-tender-repository-impl/history-tender-repository-impl';
import { DrizzleModule } from 'src/framework/infrastructure/drizzle';

@Module({
    imports: [DrizzleModule],
      controllers: [],
      providers: [
        {
          provide: 'HistoryTenderRepository',
          useClass: HistoryTenderRepositoryImpl,
        },
        {
          provide: 'HistoryTenderService',
          useClass: HistoryTenderServiceImpl,
        },        
      ],
      exports: [
        'HistoryTenderService',
        'HistoryTenderRepository',
      ],
})
export class HistoryTenderModule {}
