import { forwardRef, Module } from '@nestjs/common';
import { DrizzleModule } from 'src/framework';
import { CompanyController } from '../../controllers';
import { CompanyServiceImpl } from '../../service';
import { CompanyRepositoryImpl } from '../../repository';
import { UserCompanyServiceImpl } from '../../service/user-company-service-impl/user-company-service-impl';
import { UserCompanyRepositoryImpl } from '../../repository/user-company-repository-impl/user-company-repository-impl';
import { KeywordModule } from '../keyword/keyword.module';
import { UserCompanyTenderModule } from '../user-company-tender/user-company-tender.module';

@Module({
  imports: [forwardRef(() => DrizzleModule), KeywordModule, UserCompanyTenderModule],
  controllers: [],
  providers: [
    {
      provide: 'UserCompanyService',
      useClass: UserCompanyServiceImpl,
    },
    {
      provide: 'UserCompanyRepository',
      useClass: UserCompanyRepositoryImpl,
    },
    {
      provide: 'CompanyService',
      useClass: CompanyServiceImpl,
    },
    {
      provide: 'CompanyRepository',
      useClass: CompanyRepositoryImpl,
    },
  ],
  exports: [
    'UserCompanyService',
    'UserCompanyRepository',
    'CompanyService',
    'CompanyRepository',
  ],
})
export class CompanyModule {}
