import { forwardRef, Module } from '@nestjs/common';
import { ApplicationLogServiceImpl } from '../../service/application-log-service-impl/application-log-service-impl';
import { ApplicationLogRepositoryImpl } from '../../repository/application-log-repository-impl/application-log-repository-impl';
import { ApplicationLogController } from '../../controllers/application-log/application-log.controller';
import { DrizzleModule } from 'src/framework';

@Module({
    imports: [forwardRef(() => DrizzleModule)],
    controllers: [ApplicationLogController],
    providers: [
        {
        provide: 'ApplicationLogService',
        useClass: ApplicationLogServiceImpl,
        },
        {
        provide: 'ApplicationLogRepository',
        useClass: ApplicationLogRepositoryImpl,
        },
    ],
    exports: [
        'ApplicationLogService',
        'ApplicationLogRepository',
    ],
})
export class ApplicationLogModule {}
