import { Controller, Get, Inject, Param, Query } from '@nestjs/common';
import { ApiOkResponse, ApiParam, ApiQuery, ApiTags } from '@nestjs/swagger';
import { PrimeLogger } from 'src/framework';
import { AllowRoles, RoleShortNameEnum } from 'src/framework/infrastructure/decorators/allow-profiles/allow-roles.decorator';
import { ApiDefaultResponses } from 'src/framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator';
import { ApplicationLogService } from 'src/licitaapp/application/service/application-log-service/application-log-service.interface';
import { ApplicationLog } from 'src/licitaapp/domain';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';

@Controller('application-log')
@ApiTags('application-log')
export class ApplicationLogController {
  private readonly LOGGER = new PrimeLogger(ApplicationLogController.name);
  constructor(
    @Inject('ApplicationLogService') private readonly applicationLogService: ApplicationLogService
  ) {}
  @Get(':page/:pageSize')
  @ApiDefaultResponses()
  @AllowRoles(RoleShortNameEnum.ADMIN, RoleShortNameEnum.USER)
  @ApiOkResponse({ type: [ApplicationLog] })
  @ApiParam({ name: 'page', type: 'number' })
  @ApiParam({ name: 'pageSize', type: 'number' })
  @ApiQuery({ name: 'type', enum: ApplicationTypeEnum, required: false })
  async findAll(
    @Param('page') page: number,
    @Param('pageSize') pageSize: number,
    @Query('type') type?: ApplicationTypeEnum,
  ): Promise<ApplicationLog[]> {
    this.LOGGER.log(`Finding all application logs with page: ${page}, pageSize: ${pageSize}, type: ${type}`);
    return await this.applicationLogService.getAllPaginated(
      page,
      pageSize,
      type);
  }

}
