import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';
import { Metadata } from './metadata.to';


enum KeywordOrigin {
  USER = 'USER',
  MERCADO_PUBLICO = 'MERCADO_PUBLICO',
}

class Keyword {
  @ApiProperty({
    description: 'Keyword id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Keyword name',
    example: 'Venta',
    required: false,
  })
  value: string;

  @ApiProperty({
    description: 'User id',
    example: 1,
    required: false,
  })
  userId?: number;

  @ApiProperty({
    description: 'Keyword origin',
    enum: KeywordOrigin,
    enumName: 'KeywordOrigin',
  })
  origin?: KeywordOrigin;

  @ApiProperty({
    description: 'State bool for favorites section',
    example: true,
    required: false,
  })
  isSelected?: boolean;

  @ApiProperty({
    description: 'Company id',
    example: 1,
    required: false,
  })
  companyId?: number;

  @ApiProperty({
    description: 'Metadata',
    required: false,
  })
  metadata:Metadata | null | undefined;

  constructor(
    id: number,
    value: string,
    origin?: KeywordOrigin,
    isSelected?: boolean,
    companyId?: number,
    metadata?: Metadata | null | undefined,
  ) {
    this.id = id;
    this.value = value;
    this.origin = origin;
    this.isSelected = isSelected;
    this.companyId = companyId;
    this.metadata = metadata;
  }
}

class InsertKeyword extends OmitType(Keyword, ['id', 'isSelected']) {}

class AddCompanyKeyword extends OmitType(Keyword, [
  'id',
  'isSelected',
  'companyId',
  'metadata',
]) {}

class UpdateKeyword extends PartialType(InsertKeyword) {}

class KeywordItem extends OmitType(Keyword, ['id', 'metadata']) {}

export {
  AddCompanyKeyword,
  InsertKeyword,
  Keyword,
  KeywordItem,
  KeywordOrigin,
  UpdateKeyword
};

