import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';

class DisplayTutorial {
  @ApiProperty({
    description: 'DisplayTutorial id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'User id',
    example: 1,
    required: false,
  })
  userId: number;

  @ApiProperty({
    description: 'TUTORIAL_TYPE id',
    example: 1,
    required: true,
  })
  displayTemplateTypeId: number;

  @ApiProperty({
    description: 'title widget',
    example: 'Bienvenido a LICITAPP',
    required: true,
  })
  title: string;

  @ApiProperty({
    description: 'caption widget',
    example: 'Agrega tus empresas y nosotros nos encargaremos de entregarte información resumida de las mejores alternativas.',
    required: true,
  })
  caption: string;

  @ApiProperty({
    description: 'imageUrl widget',
    example: 'assets/images/bussiness.png',
    required: true,
  })
  imageUrl: string;

  @ApiProperty({
    description: 'Position order',
    example: 1,
    required: true,
  })
  order: number;
  
  @ApiProperty({
    description: 'short display template',
    example: 'tutorial.template.first'
  })
  shortDisplayTemplate?: string;

  @ApiProperty({
    description: 'have phone number',
    example: true
  })
  havePhoneNumber?: boolean;
  
  constructor(id: number, userId: number, displayTemplateTypeId: number, title: string, caption: string, imageUrl: string, order: number) {
    this.id = id;
    this.userId = userId;
    this.displayTemplateTypeId = displayTemplateTypeId;
    this.title = title;
    this.caption = caption;
    this.imageUrl = imageUrl;
    this.order = order;
  }

}

class InsertDisplayTutorial extends OmitType(DisplayTutorial, ['id']) {}

class UpdateDisplayTutorial extends PartialType(InsertDisplayTutorial) {}

export { InsertDisplayTutorial, UpdateDisplayTutorial, DisplayTutorial };
