import { ApiProperty, OmitType } from "@nestjs/swagger";
import { ApplicationTypeEnum } from "../enum/enum.definition";

class ApplicationLog{
    @ApiProperty({
        description: 'Company id',
        example: 1,
    })
    id: number;

    @ApiProperty({
        description: 'Usuario que ejecuta la acción',
        example: 'yperez',
    })
    userName: string;

    @ApiProperty({
        description: 'Estado de la acción',
        example: 'Terminada'
    })
    statusTypeId: number;

    @ApiProperty({
        description: 'detalle',
        example: 'Log exitoso o ERR trace',
    })
    detail: string;

    @ApiProperty({
        description: 'Action type',
        example: ApplicationTypeEnum.METADATA_TASK_LOG,
        enum: ApplicationTypeEnum,
        enumName: 'ApplicationTypeEnum',
    })
    type: ApplicationTypeEnum;

    @ApiProperty({
        description: 'Nombre estado',
        example: 'Error',
        required: false,
    })
    statusText?: string;

    @ApiProperty({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
        type: Date,
    })
    updatedAt?: Date | null;

    @ApiProperty({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
        type: Date,
    })
    createdAt?: Date | null;

    constructor(id: number, userName: string, statusTypeId: number, 
        detail: string, type: ApplicationTypeEnum){
        this.id = id;
        this.userName = userName;
        this.statusTypeId = statusTypeId;
        this.detail = detail;
        this.type = type;
    }
}

class InsertApplicationLog extends OmitType(ApplicationLog, ['id']) {}

export { ApplicationLog, InsertApplicationLog };