import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { UserMinimalTO } from './user.minimal.to';

class CompanyUserTO {
    
    @ApiProperty({
        description: 'Company id',
        example: 16,
        type: Number,
        required: true,
    })
    public companyId: number;
    @ApiProperty({
        description: 'Company name',
        example: 'Example Company',
        type: String,
        required: true,
    })
    public socialReason: string;
    @ApiPropertyOptional({
        description: 'Company fields user',
        type: String,
        required: true,
    })
    public dni: string;
    @ApiProperty({
        description: 'Company active status',
        example: true,
        type: Boolean,
        required: true,
    })
    public active: boolean;
    @ApiProperty({
        description: 'Company fields user',
        example: 15,
        type: Number,
        required: true,
    })
    public amountTenders: number;
    @ApiProperty({
        description: 'Users',
        type:() => [UserMinimalTO],
    })
    public listUsers: UserMinimalTO[];
    
    
}

export { CompanyUserTO };