import { HistoryTenderDetail, Tender, TenderTO } from "src/licitaapp/domain";

export interface UserCompanyTenderService {
   saveAll(
    userId: number,
    companyId: number,
    tenderIds: number[],
    source: string,
  ): Promise<boolean>;
  updateFavoriteUserCompanyTender(
    userId: number,
    companyId: number,
    tenderId: number,
    isFavorite: boolean,
  ): Promise<void>;
  save(
    userId: number,
    companyId: number,
    tenderId: number,
    source: string,
    matchResult: string,
  ): Promise<boolean>;
  findAllUserIdWithTenders(): Promise<number[]>;
  findTenderByUserCompanyId(
    userId: number,
    companyId: number,
  ): Promise<Tender[]>;
  getPaginatedTenders(
    userId: number,
    companyId: number,
    page: number,
    pageSize: number,
    searchType: string,
    subdivisionId: number,
    monthRequest: string,
  ): Promise<Tender[]>;
  getHistoryTendersFavorite(
    userId: number,
    dateRequest: Date,
  ): Promise<Tender[]>;
  getPaginatedHistoryTenders(
    userId: number,
    page: number,
    pageSize: number,
  ): Promise<HistoryTenderDetail[]>;
  logicalRemoveCompanyTenderUser(
    userId: number,
    companyId: number,
    tenderId: number,
  ): Promise<void>;
  erraseJoinCompanyTender(companyId: number): Promise<void>;
  countActiveTendersCompany(companyId: number): Promise<number>;
  getUsersIdsByCompanyId(companyId: number): Promise<number[]>;
  erraseUserCompanyTender(tenderIds: TenderTO[]): Promise<void>;
}
