import { TxType } from 'src/framework';
import { ApplicationLog, InsertApplicationLog } from 'src/licitaapp/domain';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';

export interface ApplicationLogService {
  save(applicationLog: InsertApplicationLog, tx?: TxType): Promise<number>;
  updateState(
    applicationLogId: number,
    statusTypeId: number,
    detail: string,
    tx?: TxType,
  ): Promise<boolean>;
  logicalRemove(applicationLogId: number, tx?: TxType): Promise<boolean>;
  getAllPaginated(
    page: number,
    pageSize: number,
    type?: ApplicationTypeEnum,
  ): Promise<ApplicationLog[]>;
}
