import { TxType } from "src/framework";
import { Company } from "src/licitaapp/domain";
import { UserMinimalTO } from "src/licitaapp/domain/dto/user.minimal.to";

export interface UserCompanyRepository {
    countUserByCompany(companyId: number): Promise<number>;
    deleteByUserCompany(userId: number, companyId: number, tx?: TxType): Promise<void>;
    findCompaniesByUserId(userId: number): Promise<Company[]>;
    getInfoUserCompany(companyId: number): Promise<UserMinimalTO[]>;
    getUserIdsWithActiveCompany(): Promise<number[]>;
    paginationByUser(userId: number, page:number, pageSize: number): Promise<Company[]>;
    save(userId: number, companyId: number, tx?: TxType): Promise<boolean>;
}
