import { HistoryTender, TenderTO } from 'src/licitaapp/domain';
import { UserHistoryTenderRow } from 'src/licitaapp/domain/type/user-history-tender.types';

export interface HistoryTenderRepository {
  save(userId: number, tenderId: number): Promise<boolean>;
  findByUserTender(
    userId: number,
    tenderId: number,
  ): Promise<UserHistoryTenderRow | undefined>;
  getListTenderHistory(userId: number): Promise<HistoryTender[]>;
  /**
   * Elimina el historial de un conjunto de licitaciones para un usuario.
   * Guarda el join a tender pero guarda el ID de licitacion.
   * @param codeTender
   * @param tenderId
   */
  erraseUserHistoryTender(tenderInfo: TenderTO): Promise<void>;
}
