import { HttpModule } from '@nestjs/axios';
import { Module } from '@nestjs/common';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { MercadoPublicoHttpConfigService } from './mp.http';
import { MercadoPublicoRepository } from './mp.repository';

@Module({
  imports: [
    ConfigModule,
    HttpModule.registerAsync({
      imports: [ConfigModule],
      useClass: MercadoPublicoHttpConfigService,
      inject: [ConfigService],
    }),
  ],
  providers: [
    {
      provide: 'MercadoPublicoRepository',
      useClass: MercadoPublicoRepository,
    }
  ],
  exports: [
    'MercadoPublicoRepository'
  ],
})
export class MercadoPublicoModule {}
