import { HttpService } from '@nestjs/axios';
import { Injectable } from '@nestjs/common';
import { firstValueFrom, map } from 'rxjs';
import { Rubro } from './types';
import { BuscarRubrosQueryParam } from './types/mp-giros.buscar-rubro.types';
import { PrimeLogger } from 'src/framework';

@Injectable()
export class MercadoPublicoGirosRepository {
  private readonly LOGGER = new PrimeLogger(MercadoPublicoGirosRepository.name);
  constructor(private readonly httpService: HttpService) {}

  async buscarGiros(
    args: BuscarRubrosQueryParam,
  ): Promise<Rubro[] | undefined> {
    const response = await firstValueFrom(
      this.httpService
        .get<Rubro[]>('/BuscarRubros', {
          params: args,
        })
        .pipe(map((response) => response.data)),
    ).catch((error) => {
      this.LOGGER.error(
        `Error retrieving giros. ${error.message}. Params: ${JSON.stringify(args)}`,
      );
      throw error;
    });
    return response;
  }
}
