import { Inject, Injectable } from '@nestjs/common';
import { UserDeviceService } from 'src/framework/application/service/user-device-service/user-device-service.interface';
import { PrimeLogger } from '../../definition/logger/app.exception.logger';
import { UserDeviceRepository } from 'src/framework/application/repository/user-device-repository/user-device-repository.interface';
import { TxType } from '../../drizzle/drizzle.types';
import { InsertUserDevice, UserDevice } from 'src/framework/domain/entities/user-device.entity';

@Injectable()
export class UserDeviceServiceImpl implements UserDeviceService {
  private readonly LOGGER = new PrimeLogger(UserDeviceServiceImpl.name);
  constructor(
    @Inject('UserDeviceRepository')
    private readonly userDeviceRepository: UserDeviceRepository,
  ) {}
  erraseUserDevice(token: string): Promise<void> {
    this.LOGGER.log(`Erasing user device with token: ${token}`);
    return this.userDeviceRepository.erraseUserDevice(token);
  }
  saveUserDevice(
    userId: number,
    data: InsertUserDevice,
    tx?: TxType,
  ): Promise<UserDevice> {
    this.LOGGER.log(`Saving user device: ${data}`);
    return this.userDeviceRepository.save(userId, data, tx);
  }
  async findTokensByUserId(userId: number): Promise<string[]> {
    this.LOGGER.log(`Finding tokens devices by user: ${userId}`);
    return await this.userDeviceRepository.findByUserId(userId);
  }
  async logicalRemove(userDeviceId: number) {
    this.LOGGER.log(`logicalRemove id ${userDeviceId}`);
    await this.userDeviceRepository.logicalRemoveById(userDeviceId);
  }
  async getAdminUserDeviceTokens(): Promise<string[]> {
    this.LOGGER.log(`getAdminUserDeviceTokens`);
    return await this.userDeviceRepository.getAdminUserDeviceTokens();
  }
}
