import { Module } from '@nestjs/common';
import { DrizzleModule } from '../../drizzle';
import { UserCampaignsController } from '../../controllers/user-campaigns/user-campaigns.controller';
import { UserCampaignsServiceImpl } from '../../service/user-campaigns-service-impl/user-campaigns-service-impl';
import { UserCampaignsRepositoryImpl } from '../../repository/user-campaigns-repository-impl/user-campaigns-repository-impl';

@Module({
    imports: [DrizzleModule],
    controllers: [UserCampaignsController],
    providers: [
        {
            provide: 'UserCampaignsService',
            useClass: UserCampaignsServiceImpl,
        },
        {
            provide: 'UserCampaignsRepository',
            useClass: UserCampaignsRepositoryImpl,
        }
    ],
    exports: [
        'UserCampaignsService',
        'UserCampaignsRepository',
    ],
})
export class UserCampaignsModule {}
