import { Module } from '@nestjs/common';
import { TypeMasterController } from '../../controllers/type-master/type-master.controller';
import { DrizzleModule } from '../../drizzle';
import { TypeMasterServiceImpl } from '../../service/type-master-service-impl/type-master-service-impl';
import { TypeMasterRepositoryImpl } from '../../repository/type-master-repository-impl/type-master-repository-impl';

@Module({
    imports: [DrizzleModule],
    controllers: [TypeMasterController],
    providers: [
        {
          provide: 'TypeMasterRepository',
          useClass: TypeMasterRepositoryImpl,
        },
        {
          provide: 'TypeMasterService',
          useClass: TypeMasterServiceImpl,
      },
      ],
      exports: [
        'TypeMasterRepository',
        'TypeMasterService',
      ],
})
export class TypeMasterModule {}
