import { forwardRef, Module } from '@nestjs/common';
import { NotificationController } from '../../controllers/notification/notification.controller';
import { EmailServiceImpl } from '../../service/email-service-impl/email-service-impl';
import { MailerModule } from '@nestjs-modules/mailer';
import { ConfigModule, ConfigService } from '@nestjs/config';
import { DrizzleModule } from '../../drizzle';
import { FirebaseImplService } from '../../service';
import { UserDeviceModule } from '../user-device/user-device.module';
import { NotificationRecordModule } from '../notification-record/notification-record.module';

@Module({
  controllers: [NotificationController],
  imports: [
    ConfigModule,
    DrizzleModule,
    UserDeviceModule,
    NotificationRecordModule,
    MailerModule.forRootAsync({
      imports: [ConfigModule],
      useFactory: async (configService: ConfigService) => ({
        transport: {
          service: 'gmail',
          port: 587,
          secure: false,
          logger: true,
          debug: true,
          secureConnection: false,
          auth: {
            user: configService.get<string>('MAIL_USER'),
            pass: configService.get<string>('MAIL_PASS'),
          },
          tls: {
            rejectUnauthorized: false
          }
        },
        defaults: {
          from: `MySCAR Bienvenido <${configService.get<string>('MAIL_FROM')}>`,
        },
      }),
      inject: [ConfigService],
    }),
  ],
  providers: [
    {
      provide: 'EmailService',
      useClass: EmailServiceImpl,
    },
    {
      provide: 'FirebaseService',
      useClass: FirebaseImplService,
    },
  ],
  exports: [
    'EmailService',
    'FirebaseService',
  ],
})
export class NotificationModule {

}