import { Module } from '@nestjs/common';
import { DrizzleModule } from '../../drizzle';
import { GeoController } from '../../controllers/geo/geo.controller';
import { GeoServiceImpl } from '../../service/geo-service-impl/geo-service-impl';
import { GeoRepositoryImpl } from '../../repository/geo-repository-impl/geo-repository-impl';

@Module({
    imports: [DrizzleModule],
    controllers: [GeoController],
    providers: [
        {
          provide: 'GeoRepository',
          useClass: GeoRepositoryImpl,
        },
        {
          provide: 'GeoService',
          useClass: GeoServiceImpl,
      },
      ],
      exports: [
        'GeoRepository',
        'GeoService',
      ],
})
export class GeoModule {}
