import { ConfigModule } from '@nestjs/config';
import { Test, TestingModule } from '@nestjs/testing';
import { DrizzleModule } from './drizzle.module';
import { DBConfigService } from './drizzle.provider';

jest.mock('drizzle-orm/mysql2/migrator', () => ({
  migrate: jest.fn().mockImplementation(() => Promise.resolve(true)),
}));

describe('DBConfigService', () => {
  let provider: DBConfigService;

  beforeEach(async () => {
    const module: TestingModule = await Test.createTestingModule({
      imports: [
        ConfigModule.forRoot({
          isGlobal: true,
          envFilePath: '.env.dev',
        }),
        DrizzleModule,
      ],
      providers: [DBConfigService],
    }).compile();

    provider = module.get<DBConfigService>(DBConfigService);
  });

  it('should be defined', () => {
    expect(provider).toBeDefined();
  });

  describe('migrate', () => {
    it('should call migrate method of DBConfigService', async () => {
      // eslint-disable-next-line @typescript-eslint/no-var-requires
      const { migrate } = require('drizzle-orm/mysql2/migrator');
      const result = await provider.migrate();
      expect(migrate).toHaveBeenCalled();
      expect(result).toBe(true);
    });

    it('should return false if migrate fails', async () => {
      // eslint-disable-next-line @typescript-eslint/no-var-requires
      const { migrate } = require('drizzle-orm/mysql2/migrator');
      migrate.mockImplementation(() => Promise.reject(new Error('Error')));
      const result = await provider.migrate();
      expect(result).toBe(false);
    });
  });
});
