import { createParamDecorator, ExecutionContext } from '@nestjs/common';
import { Request } from 'express';

/**
 * Custom decorator to extract the decoded token from the request.
 *
 * @param data - Custom data passed to the decorator (not used here).
 * @param ctx - The execution context, which provides access to the request.
 * @returns The decoded token from the request.
 */
export const DecodedToken = createParamDecorator(
  (data: unknown, ctx: ExecutionContext) => {
    const request = ctx.switchToHttp().getRequest<Request>();
    return request.decodedToken;
  },
);
