import { applyDecorators } from '@nestjs/common';
import {
  ApiBadRequestResponse,
  ApiBearerAuth,
  ApiForbiddenResponse,
  ApiUnauthorizedResponse,
  getSchemaPath,
} from '@nestjs/swagger';
import { ApiErrorExamples, ApiErrorResponse } from '../../definition';


/**
 * A custom decorator that applies default API response decorators to an endpoint.
 *
 * This decorator adds the following responses:
 * - 400 Bad Request
 * - 401 Unauthorized
 * - 403 Forbidden
 *
 * It also adds the Bearer authentication decorator.
 *
 * @returns {Function} A function that applies the decorators.
 */
const ApiDefaultResponses = () => {
  return applyDecorators(
    ApiBadRequestResponse({
      schema: {
        $ref: getSchemaPath(ApiErrorResponse),
        example: ApiErrorExamples.BAD_REQUEST,
      },
    }),
    ApiUnauthorizedResponse({
      schema: {
        $ref: getSchemaPath(ApiErrorResponse),
        example: ApiErrorExamples.UNAUTHORIZED,
      },
    }),
    ApiForbiddenResponse({
      schema: {
        $ref: getSchemaPath(ApiErrorResponse),
        example: ApiErrorExamples.FORBIDEN,
      },
    }),
    ApiBearerAuth(),
  );
};

export { ApiDefaultResponses };
