import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';

class User {
  @ApiProperty({
    description: 'User id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'User name',
    example: 'John Doe',
  })
  name: string;

  @ApiProperty({
    description: 'User email',
    example: 'john@doe.com',
  })
  email: string;

  @ApiProperty({
    description: 'User last name',
    example: 'Doe',
    required: false,
    type: String,
  })
  lastName?: string | null | undefined;

  @ApiProperty({
    description: 'User second last name',
    example: 'Doe',
    required: false,
    type: String,
  })
  lastname2?: string | null | undefined;

  @ApiProperty({
    description: 'User cell phone',
    example: '1234567890',
    required: false,
    type: String,
  })
  cellPhone?: string | null | undefined;

  @ApiProperty({
    description: 'User external id',
    example: '1234567890',
    required: false,
    type: String,
  })
  externalId?: string;

  @ApiProperty({
    description: 'Last update date',
    example: '1991-01-01T00:00:00.000Z',
    required: false,
  })
  aggrementDate?: Date | null;

  constructor(
    id: number,
    name: string,
    email: string,
    lastName?: string | null | undefined,
    lastName2?: string | null | undefined,
    cellPhone?: string | null | undefined,
    externalId?: string,
    aggrementDate?: Date | null,
  ) {
    this.id = id;
    this.name = name;
    this.email = email;
    this.lastName = lastName;
    this.lastname2 = lastName2;
    this.cellPhone = cellPhone;
    this.externalId = externalId;
    this.aggrementDate = aggrementDate;
  }
}

class InsertUser extends OmitType(User, ['id']) {}

class UpdateUser extends PartialType(InsertUser) {}

export { InsertUser, UpdateUser, User };
