import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';

class UserRequest {
  @ApiProperty({
    description: 'UserRequest id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'Company id',
    example: 1,
    required: true,
  })
  companyId: number;

  @ApiProperty({
    description: 'titulo de la solicitud',
    example: 'title',
    type: String,
    required: true,
  })
  title: string;

  @ApiProperty({
    description: 'description of the request',
    example: 'description',
    type: String,
    required: false,
  })
  description?: string;

  @ApiProperty({
    description: 'Tender id',
    example: 1,
    type: Number,
    required: true,
  })
  tenderId: number | null;

  @ApiProperty({
    description: 'User id',
    example: 1,
    required: false,
  })
  userId?: number;

  @ApiProperty({
    description: 'State request type id',
    example: 1,
    required: true,
  })
  stateRequestTypeId: number;

  @ApiProperty({
    description: 'Creation date',
    example: '1991-01-01T00:00:00.000Z',
    type: Date,
    required: false,
  })
  createdAt?: Date | null;

  @ApiProperty({
    description: 'Last update date',
    example: '1991-01-01T00:00:00.000Z',
    type: Date,
    required: false,
  })
  updatedAt?: Date | null;

  @ApiProperty({
    description: 'short display template',
    example: 'tutorial.template.first',
    required: false,
  })
  shortStateUserRequest?: string;

  @ApiProperty({
    description: 'short default text template',
    example: 'Solicitado',
    required: false,
  })
  dafaultTextStateUserRequest?: string;

  constructor(
    id: number,
    companyId: number,
    stateRequestTypeId: number,
    title: string,
    tenderId: number | null,
    description?: string,
    userId?: number,
    createdAt?: Date | null,
    updatedAt?: Date | null,
    shortStateUserRequest?: string,
    dafaultTextStateUserRequest?: string,
  ) {
    this.id = id;
    this.companyId = companyId;
    this.stateRequestTypeId = stateRequestTypeId;
    this.userId = userId;
    this.tenderId = tenderId;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.title = title;
    this.description = description;
    this.shortStateUserRequest = shortStateUserRequest;
    this.dafaultTextStateUserRequest = dafaultTextStateUserRequest;
  }
}

class InsertUserRequest extends OmitType(UserRequest, [
  'id',
  'userId',
  'createdAt',
  'updatedAt',
  'shortStateUserRequest',
  'dafaultTextStateUserRequest',
]) {}
class UpdateUserRequest extends PartialType(UserRequest) {}

export { InsertUserRequest, UserRequest, UpdateUserRequest };
