import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';

class UserDevice {
  @ApiProperty({
    description: 'UserDevice id',
    example: 1,
  })
  id: number;

  @ApiProperty({
    description: 'User id',
    example: 1,
    required: true,
  })
  userId: number;

  @ApiProperty({
    description: 'token device logged',
    example: 'cf_iAR3LSpeAXjhuDKW29R:APA91bFQMNh8-tgt7vcJaSGc2wy5GhTPkmD69U7p-7nIp0d0g9GgLSFZ_pwmWTQFx7CvaQEdFoMyghGJPrfKHYAgvC9krqX0lIN5KAQ0YO984l55YxN6ylnL9Pdihy52qU9ZjY833Ppv',
    required: true,
  })
  token: string;

  @ApiProperty({
    description: 'Information about device',
    example: 'Device information',
  })
  information: string;

  constructor(id: number, userId: number, token: string, information: string) {
    this.id = id;
    this.userId = userId;
    this.token = token;
    this.information = information;
  }

}

class InsertUserDevice extends OmitType(UserDevice, ['id']) {}

class UpdateUserDevice extends PartialType(InsertUserDevice) {}

export { InsertUserDevice, UpdateUserDevice, UserDevice };