import { ApiProperty, OmitType, PartialType } from '@nestjs/swagger';

class NotificationRecord {
    @ApiProperty({
        description: 'Keyword id',
        example: 1,
    })
    id: number;

    @ApiProperty({
        description: 'User id',
        example: 1,
        required: true,
    })
    userId: number;

    @ApiProperty({
        description: 'Title notification',
        example: 'Nueva licitacion',
        required: true,
    })
    title: string;

    @ApiProperty({
        description: 'Description notification',
        example: 'Se ha publicado una nueva licitacion',
        required: true,
    })
    defaultMessage: string;

    @ApiProperty({
        description: 'Tender id',
        example: 1,
        required: false,
    })
    tenderId?: number| null| undefined;

    @ApiProperty({
        description: 'Subdivision id',
        example: 1,
        required: false,
    })
    subdivisionId?: number;

    @ApiProperty({
        description: 'State bool for favorites section',
        example: true,
        required: false,
    })
    active?: boolean;

    @ApiProperty({
        description: 'Creation date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    })
    createdAt?: Date | null;

    @ApiProperty({
        description: 'Last update date',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    })
    updatedAt?: Date | null;

    @ApiProperty({
        description: 'Month filter tender',
        example: '1991-01-01T00:00:00.000Z',
        required: false,
    })
    monthFilterTender?: Date | null;

    @ApiProperty({
        description: 'Amount words',
        example: 0,
        required: false,
    })
    amountWords?: number;

    @ApiProperty({
        description: 'Amount geo',
        example: 0,
        required: false,
    })
    amountGeo?: number;

    @ApiProperty({
        description: 'Send email',
        example: true,
        required: false,
})
    sendEmail?: boolean;

    userEmail?: string | null;

    isAdmin?: boolean | null;
  
    constructor(id: number, userId: number, title: string, defaultMessage: string, 
        active?: boolean, createdAt?: Date | null, updatedAt?: Date | null, 
        tenderId?: number, subdivisionId?: number, monthFilterTender?: Date | null,
        sendEmail?: boolean, amountWords?: number, amountGeo?: number, isAdmin?: boolean | null
    ) {
        this.id = id;
        this.userId = userId;
        this.title = title;
        this.defaultMessage = defaultMessage;
        this.active = active;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.tenderId = tenderId;
        this.subdivisionId = subdivisionId;
        this.monthFilterTender = monthFilterTender;
        this.sendEmail = sendEmail;
        this.amountWords = amountWords;
        this.amountGeo = amountGeo;
        this.isAdmin = isAdmin;
    }
}

class InsertNotificationRecord extends OmitType(NotificationRecord, ['id']) {}

class UpdateNotificationRecord extends PartialType(InsertNotificationRecord) {}

export { InsertNotificationRecord, UpdateNotificationRecord, NotificationRecord };