import { ApiProperty } from '@nestjs/swagger';

class Country {
  @ApiProperty({ description: 'Country id', example: 1 })
  id: number;
  @ApiProperty({ description: 'ISO code', example: 'CL' })
  code: string;
  @ApiProperty({ description: 'ISO3 code', example: 'CHL' })
  iso3: string;
  @ApiProperty({ description: 'Country code', example: '152' })
  number: string;
  @ApiProperty({ description: 'Country name', example: 'Chile' })
  name: string;
  @ApiProperty({
    description: 'Country full name',
    example: 'Republic of Chile',
  })
  fullName: string;

  constructor(
    id: number,
    code: string,
    iso3: string,
    number: string,
    name: string,
    fullName: string,
  ) {
    this.id = id;
    this.code = code;
    this.iso3 = iso3;
    this.number = number;
    this.name = name;
    this.fullName = fullName;
  }
}

export { Country };