import { ApiProperty } from '@nestjs/swagger';

export class PageMeta {
  @ApiProperty({ required: true })
  totalItems: number;
  @ApiProperty({ required: true })
  itemCount: number;
  @ApiProperty({ required: true })
  itemsPerPage: number;
  @ApiProperty({ required: true })
  totalPages: number;
  @ApiProperty({ required: true })
  currentPage: number;
}

export abstract class Page<T> {
  data: T[];
  @ApiProperty({ required: true })
  meta: PageMeta;
}

export class PageParam {
  @ApiProperty({ default: 1, required: false })
  page: number;
}
export class LimitParam {
  @ApiProperty({ default: 10, required: false })
  limit: number;
}
