import { TxType, InsertUser, Role, UpdateUser, User, RecordTO, UserRoleTO } from 'src/framework';

export interface UserService {
  createUser(user: InsertUser): Promise<User>;
  createOrUpdate(externalId: string, user: InsertUser): Promise<User>;
  getUserById(id: number, tx?: TxType): Promise<User | null | undefined>;
  getUserByExternalId(externalId: string): Promise<User | null | undefined>;
  getUserByEmail(email: string): Promise<User | null | undefined>;
  updateUser(id: number, user: UpdateUser): Promise<User>;
  getAllUsers(): Promise<User[]>;
  updateAggrement(user: User): Promise<string>;
  unsubscribe(user: User): Promise<void>;
  registerUserByProfile(recordTO: RecordTO): Promise<boolean> ;

  errase(user: User): Promise<void>;
  findEmailsAdmin(): Promise<string[]>;
  updateProfiles(params: UserRoleTO): Promise<string>;
   
}