import { TxType } from "src/framework";
import { InsertUserDevice, UserDevice } from "src/framework/domain/entities/user-device.entity";

export interface UserDeviceService {
    saveUserDevice(userId: number, data: InsertUserDevice, tx?: TxType): Promise<UserDevice>;
    findTokensByUserId(userId: number): Promise<string[]>;
    logicalRemove(userDeviceId: number): Promise<void>;
    erraseUserDevice(token: string): Promise<void>;
    getAdminUserDeviceTokens(): Promise<string[]>;
}

