import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import {
  DrizzleModule,
  GeoModule,
  NotificationModule,
  PrimeFirebaseAuthGuard,
  RoleModule,
  TypeMasterModule,
  UserModule,
  UserRequestModule,
  UserRoleModule,
} from './framework';
import { KeywordModule } from './licitaapp/infrastructure/module/keyword/keyword.module';
import { UserDeviceModule } from './framework/infrastructure/module/user-device/user-device.module';
import { HistoryTenderModule } from './licitaapp/infrastructure/module/history-tender/history-tender.module';
import { CompanyModule, MercadoPublicoModule, TenderModule } from './licitaapp';
import { ApplicationLogModule } from './licitaapp/infrastructure/module/application-log/application-log.module';
import { NotificationRecordModule } from './framework/infrastructure/module/notification-record/notification-record.module';
import { ScheduleMpModule } from './licitaapp/infrastructure/module/schedule-mp/schedule-mp.module';
import { ScheduleModule } from '@nestjs/schedule';
import { APP_GUARD } from '@nestjs/core';
import { UserCampaignsModule } from './framework/infrastructure/module/user-campaigns/user-campaigns.module';
import { FwkCacheModule } from './framework/infrastructure/module/fwk-cache/fwk-cache.module';

@Module({
  imports: [
    ConfigModule.forRoot({
      isGlobal: true,
      envFilePath: '.env.dev',
    }),
    ScheduleModule.forRoot(),
    FwkCacheModule,
    DrizzleModule,
    NotificationModule,
    UserDeviceModule,
    RoleModule,
    UserRoleModule,
    KeywordModule,
    UserModule,
    TypeMasterModule,
    GeoModule,
    UserRequestModule,
    HistoryTenderModule,
    CompanyModule,
    TenderModule,
    ApplicationLogModule,
    NotificationRecordModule,
    ScheduleMpModule,
    UserCampaignsModule,
    MercadoPublicoModule
  ],
  providers: [
    {
      provide: APP_GUARD,
      useClass: PrimeFirebaseAuthGuard,
    },
  ],
})
export class AppModule {}
