"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserCompanyTenderServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCompanyTenderServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
let UserCompanyTenderServiceImpl = UserCompanyTenderServiceImpl_1 = class UserCompanyTenderServiceImpl {
    constructor(userCompanyTenderRepository) {
        this.userCompanyTenderRepository = userCompanyTenderRepository;
        this.LOGGER = new framework_1.PrimeLogger(UserCompanyTenderServiceImpl_1.name);
    }
    erraseUserCompanyTender(tenderIds) {
        this.LOGGER.log(`erraseUserCompanyTender - tenderIds: ${tenderIds.length}`);
        return this.userCompanyTenderRepository.erraseUserCompanyTender(tenderIds);
    }
    saveAll(userId, companyId, tenderIds, source) {
        this.LOGGER.log(`saveAll - userId: ${userId}, companyId: ${companyId}, tenderIds: ${tenderIds.length}, source: ${source}`);
        return this.userCompanyTenderRepository.saveAll(userId, companyId, tenderIds, source);
    }
    updateFavoriteUserCompanyTender(userId, companyId, tenderId, isFavorite) {
        this.LOGGER.log(`updateFavoriteUserCompanyTender - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}, isFavorite: ${isFavorite}`);
        return this.userCompanyTenderRepository.updateFavoriteUserCompanyTender(userId, companyId, tenderId, isFavorite);
    }
    save(userId, companyId, tenderId, source, matchResult) {
        this.LOGGER.log(`save - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}, source: ${source}, matchResult: ${matchResult}`);
        return this.userCompanyTenderRepository.save(userId, companyId, tenderId, source, matchResult);
    }
    findAllUserIdWithTenders() {
        this.LOGGER.log('findAllUserIdWithTenders - Retrieving all user IDs with tenders');
        return this.userCompanyTenderRepository.findAllUserIdWithTenders();
    }
    findTenderByUserCompanyId(userId, companyId) {
        this.LOGGER.log(`findTenderByUserCompanyId - userId: ${userId}, companyId: ${companyId}`);
        return this.userCompanyTenderRepository.findTenderByUserCompanyId(userId, companyId);
    }
    getPaginatedTenders(userId, companyId, page, pageSize, searchType, subdivisionId, monthRequest) {
        this.LOGGER.log(`getPaginatedTenders - userId: ${userId}, companyId: ${companyId}, page: ${page}, pageSize: ${pageSize}, searchType: ${searchType}, subdivisionId: ${subdivisionId}, monthRequest: ${monthRequest}`);
        return this.userCompanyTenderRepository.getPaginatedTenders(userId, companyId, page, pageSize, searchType, subdivisionId, monthRequest);
    }
    getHistoryTendersFavorite(userId, dateRequest) {
        this.LOGGER.log(`getHistoryTendersFavorite - userId: ${userId}, dateRequest: ${dateRequest}`);
        return this.userCompanyTenderRepository.getHistoryTendersFavorite(userId, dateRequest);
    }
    getPaginatedHistoryTenders(userId, page, pageSize) {
        this.LOGGER.log(`getPaginatedHistoryTenders - userId: ${userId}, page: ${page}, pageSize: ${pageSize}`);
        return this.userCompanyTenderRepository.getPaginatedHistoryTenders(userId, page, pageSize);
    }
    logicalRemoveCompanyTenderUser(userId, companyId, tenderId) {
        this.LOGGER.log(`logicalRemoveCompanyTenderUser - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}`);
        return this.userCompanyTenderRepository.logicalRemoveCompanyTenderUser(userId, companyId, tenderId);
    }
    erraseJoinCompanyTender(companyId) {
        this.LOGGER.log(`erraseJoinCompanyTender - companyId: ${companyId}`);
        return this.userCompanyTenderRepository.erraseJoinCompanyTender(companyId);
    }
    countActiveTendersCompany(companyId) {
        this.LOGGER.log(`countActiveTendersCompany - companyId: ${companyId}`);
        return this.userCompanyTenderRepository.countActiveTendersCompany(companyId);
    }
    getUsersIdsByCompanyId(companyId) {
        this.LOGGER.log(`getUsersIdsByCompanyId - companyId: ${companyId}`);
        return this.userCompanyTenderRepository.getUsersIdsByCompanyId(companyId);
    }
};
exports.UserCompanyTenderServiceImpl = UserCompanyTenderServiceImpl;
exports.UserCompanyTenderServiceImpl = UserCompanyTenderServiceImpl = UserCompanyTenderServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserCompanyTenderRepository')),
    __metadata("design:paramtypes", [Object])
], UserCompanyTenderServiceImpl);
//# sourceMappingURL=user-company-tender-service-impl.js.map