"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var UserCompanyServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserCompanyServiceImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
let UserCompanyServiceImpl = UserCompanyServiceImpl_1 = class UserCompanyServiceImpl {
    constructor(userCompanyRepository) {
        this.userCompanyRepository = userCompanyRepository;
        this.LOGGER = new framework_1.PrimeLogger(UserCompanyServiceImpl_1.name);
    }
    async countUserByCompany(companyId) {
        this.LOGGER.log(`Counting users by company: ${companyId}`);
        return await this.userCompanyRepository.countUserByCompany(companyId);
    }
    async getInfoUserCompany(companyId) {
        this.LOGGER.log(`Getting info user company for company: ${companyId}`);
        return await this.userCompanyRepository.getInfoUserCompany(companyId);
    }
    async getUserIdsWithActiveCompany() {
        this.LOGGER.log('Getting user ids with active company');
        return await this.userCompanyRepository.getUserIdsWithActiveCompany();
    }
    async saveUserCompany(userId, companyId, tx) {
        this.LOGGER.log(`Saving user company: ${userId} - ${companyId}`);
        return await this.userCompanyRepository.save(userId, companyId, tx);
    }
    async findCompaniesByUserId(userId) {
        this.LOGGER.log(`Finding companies by user: ${userId}`);
        return await this.userCompanyRepository.findCompaniesByUserId(userId);
    }
    async paginationByUser(userId, page, pageSize) {
        this.LOGGER.log(`paginationByUser user ${userId} page ${page} pageSize ${pageSize}`);
        return await this.userCompanyRepository.paginationByUser(userId, page, pageSize);
    }
    async deleteByUserCompany(userId, companyId) {
        this.LOGGER.log(`deleteByUserCompany userId ${userId} companyId ${companyId}`);
        await this.userCompanyRepository.deleteByUserCompany(userId, companyId);
    }
};
exports.UserCompanyServiceImpl = UserCompanyServiceImpl;
exports.UserCompanyServiceImpl = UserCompanyServiceImpl = UserCompanyServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('UserCompanyRepository')),
    __metadata("design:paramtypes", [Object])
], UserCompanyServiceImpl);
//# sourceMappingURL=user-company-service-impl.js.map