import { TxType } from 'src/framework';
import { UserCompanyRepository, UserCompanyService } from 'src/licitaapp';
import { Company } from 'src/licitaapp/domain';
import { UserMinimalTO } from 'src/licitaapp/domain/dto/user.minimal.to';
export declare class UserCompanyServiceImpl implements UserCompanyService {
    private readonly userCompanyRepository;
    private readonly LOGGER;
    constructor(userCompanyRepository: UserCompanyRepository);
    countUserByCompany(companyId: number): Promise<number>;
    getInfoUserCompany(companyId: number): Promise<UserMinimalTO[]>;
    getUserIdsWithActiveCompany(): Promise<number[]>;
    saveUserCompany(userId: number, companyId: number, tx?: TxType): Promise<boolean>;
    findCompaniesByUserId(userId: number): Promise<Company[]>;
    paginationByUser(userId: number, page: number, pageSize: number): Promise<Company[]>;
    deleteByUserCompany(userId: number, companyId: number): Promise<void>;
}
