"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TenderServiceImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderServiceImpl = void 0;
const axios_1 = require("@nestjs/axios");
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const rxjs_1 = require("rxjs");
const framework_1 = require("../../../../framework");
const domain_1 = require("../../../domain");
const enum_definition_1 = require("../../../domain/enum/enum.definition");
const util_1 = require("../../../domain/util");
const util_2 = require("util");
let TenderServiceImpl = TenderServiceImpl_1 = class TenderServiceImpl {
    constructor(tenderRepository, companyService, userHistoryTenderService, matchWordsService, userCompanyTenderRepository, notificationRecordService, geoService, configService, httpService, firebaseService, keywordService, userService, applicationLogService, userCompanyService, userRequestService) {
        this.tenderRepository = tenderRepository;
        this.companyService = companyService;
        this.userHistoryTenderService = userHistoryTenderService;
        this.matchWordsService = matchWordsService;
        this.userCompanyTenderRepository = userCompanyTenderRepository;
        this.notificationRecordService = notificationRecordService;
        this.geoService = geoService;
        this.configService = configService;
        this.httpService = httpService;
        this.firebaseService = firebaseService;
        this.keywordService = keywordService;
        this.userService = userService;
        this.applicationLogService = applicationLogService;
        this.userCompanyService = userCompanyService;
        this.userRequestService = userRequestService;
        this.LOGGER = new framework_1.PrimeLogger(TenderServiceImpl_1.name);
        this.textApiKey = this.configService.get('TEXTRAZOR_API_KEY');
        this.textApiUrl = this.configService.get('TEXTRAZOR_API_URL');
        this.maxTextRetries = this.configService.get('TEXTRAZOR_MAX_RETRIES', 5);
        this.tenderLimitDays = this.configService.get('TENDERS_LIMIT_DAYS', '5');
        this.isCronActive = this.configService.get('CRON_JOB_ENABLED', 'true').toLowerCase() ===
            'true';
    }
    async erraseOldTenders() {
        this.LOGGER.warn(`erraseOldTenders - START`);
        const idsTendersLogicalRemove = await this.tenderRepository.getLogicalRemoveTenderIds();
        this.LOGGER.warn(`erraseOldTenders - idsTendersLogicalRemove size: ${idsTendersLogicalRemove.length}`);
        const chunkSize = 500;
        for (let i = 0; i < idsTendersLogicalRemove.length; i += chunkSize) {
            const chunk = idsTendersLogicalRemove.slice(i, i + chunkSize);
            await this.userRequestService.erraseUserRequests(chunk);
            for (const tenderInfo of chunk) {
                await this.userHistoryTenderService.erraseUserHistoryTender(tenderInfo);
            }
            await this.userCompanyTenderRepository.erraseUserCompanyTender(chunk);
            await this.notificationRecordService.erraseNotificationRecordsByTender(chunk.map(t => t.tenderId));
            await this.tenderRepository.erraseByListId(chunk.map(t => t.tenderId));
        }
        return 'true';
    }
    async tenderTaskPerDay() {
        this.LOGGER.warn(`tenderTaskPerDay - START`);
        const applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG);
        await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, applicationLogId, this.checkTenderWithCloseDate.bind(this));
    }
    async getListTenderHistory(userId) {
        this.LOGGER.log(`LIST HISTORY_TENDER - userId: ${userId}`);
        return await this.userHistoryTenderService.getListTenderHistory(userId);
    }
    async logicalRemoveCompanyTenderUser(userId, companyId, tenderId) {
        this.LOGGER.log(`logicalRemoveCompanyTenderUser userId ${userId} companyId ${companyId} tenderId ${tenderId}`);
        return await this.userCompanyTenderRepository.logicalRemoveCompanyTenderUser(userId, companyId, tenderId);
    }
    async updateFavoriteUserCompanytender(userId, companyId, tenderId, isFavorite) {
        this.LOGGER.log(`updateFavoriteUserCompanytender - userId: ${userId}, companyId: ${companyId}, tenderId: ${tenderId}, isFavorite: ${isFavorite}`);
        return await this.userCompanyTenderRepository.updateFavoriteUserCompanyTender(userId, companyId, tenderId, isFavorite);
    }
    async upsert(tender) {
        this.LOGGER.log(`upsert tender - code: ${tender.code}`);
        return await this.tenderRepository.upsert(tender);
    }
    async tenderTaskByHour() {
        this.LOGGER.warn(`checkTenderByHour - START`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG);
    }
    async logAndExecute(type, applicationLogId, action) {
        this.LOGGER.log(`logAndExecute - type: ${type}, applicationLogId: ${applicationLogId}`);
        const startTime = Date.now();
        try {
            const message = await action(applicationLogId);
            const duration = Date.now() - startTime;
            await this.applicationLogService.updateState(applicationLogId, 10, `Duración: ${duration / 1000} s. ${message}.`);
        }
        catch (error) {
            const duration = Date.now() - startTime;
            this.LOGGER.error(`logAndExecute - ${type} - Error: ${error}`);
            await this.applicationLogService.updateState(applicationLogId, 9, this.evalTextLarge(`Duración: ${duration / 1000} s. Error: ${(0, util_2.inspect)(error)}.`));
        }
    }
    evalTextLarge(text) {
        if (text.length > 65535) {
            return text.substring(0, 65534);
        }
        return text;
    }
    async checkTenderFavoritesToClose(applicationLogId) {
        this.LOGGER.log(`checkTenderFavoritesToClose - START`);
        const arrayDaysToClose = this.tenderLimitDays.split('-');
        const messageTxt = `checkTenderFavoritesToClose - applicationLogId: ${applicationLogId} - arrayDaysToClose: ${arrayDaysToClose}`;
        this.LOGGER.log(`checkTenderFavoritesToClose - arrayDaysToClose: ${arrayDaysToClose}`);
        const usersIds = await this.userCompanyTenderRepository.findAllUserIdWithTenders();
        let daterequest;
        for (const dateStr of arrayDaysToClose) {
            daterequest = util_1.TenderUtil.subtractDays(util_1.TenderUtil.getSystemDateDDMMYYYY(), (+dateStr) * -1);
            messageTxt.concat(`. Processing date: ${daterequest.toLocaleDateString('es-CL', { day: '2-digit', month: '2-digit', year: 'numeric' })}`);
            for (const userId of usersIds) {
                const tenders = await this.userCompanyTenderRepository.getHistoryTendersFavorite(userId, daterequest);
                messageTxt.concat(`. Processing userId: ${userId} - tenders size: ${tenders.length}`);
                for (const tender of tenders) {
                    const notificationsArray = [];
                    notificationsArray.push({
                        userId: userId,
                        title: `Licitación favorita por cerrar`,
                        defaultMessage: `Licitación ${tender.code} favorita por cerrar en ${dateStr} día(s)`,
                        active: true,
                        tenderId: tender.id,
                        amountGeo: tenders.length,
                    });
                    notificationsArray.length > 0 && await this.notificationRecordService.saveAll(notificationsArray);
                }
                await this.firebaseService.groupNotifications(userId);
            }
        }
        this.LOGGER.log(`checkTenderFavoritesToClose - END`);
        return messageTxt;
    }
    async checkNewTendersUserCompany(applicationLogId) {
        let systemHour = util_1.TenderUtil.getCurrentSystemDate();
        let messageTxt = `ApplicationLogId: ${applicationLogId} - START - systemHour: ${systemHour.getHours()}`;
        this.LOGGER.warn(`checkPerQuarterActions - applicationLogId: ${applicationLogId} - START - systemHour: ${systemHour.getHours()}`);
        if (systemHour.getHours() >= 8 && systemHour.getHours() <= 20) {
            this.LOGGER.warn(`Eval checkNewTenders8AM`);
            const usersIds = await this.userCompanyService.getUserIdsWithActiveCompany();
            this.LOGGER.warn(`checkPerQuarterActions - usersIds: ${usersIds.length}`);
            messageTxt = messageTxt.concat(`. Checking tender to ${usersIds.length} users`);
            for (const userId of usersIds) {
                const conpanyList = await this.userCompanyService.findCompaniesByUserId(userId);
                messageTxt = messageTxt.concat(`. Checking to userId: ${userId} with ${conpanyList.length} companies`);
                try {
                    for (const companyItem of conpanyList) {
                        this.LOGGER.log(`checkPerQuarterActions - userId: ${userId} companyId: ${companyItem.id}`);
                        await this.searchTendersDB({ companyId: companyItem.id, userId }, false);
                    }
                    await new Promise(resolve => setTimeout(resolve, 2000));
                }
                catch (error) {
                    this.LOGGER.error(`checkPerQuarterActions - reviewTenderState user: ${userId} - Error: ${error}`);
                    throw error;
                }
            }
        }
        return messageTxt;
    }
    async tenderTaskBy2Hour() {
        this.LOGGER.warn(`checkTenderBy2Hour - START`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.TENDER_WITHOUT_META_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG);
    }
    async createApplicationLogID(type) {
        const applicationLogId = await this.applicationLogService.save({
            userName: 'SYSTEM',
            statusTypeId: 8,
            detail: 'Iniciado a las ' + util_1.TenderUtil.getCurrentSystemDate().toLocaleTimeString(),
            type,
        });
        return applicationLogId;
    }
    async tenderTaskEvery5Minutes() {
        this.LOGGER.warn(`tenderTaskPer5Minutes - START`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG);
        this.LOGGER.warn(`tenderTaskPer5Minutes - END`);
    }
    async checkTenderSubdivision(applicationLogId) {
        const tendersWihoutCity = await this.tenderRepository.findWithoutSubdivision();
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Licitaciones sin ciudades: ${tendersWihoutCity.length}`;
        if (tendersWihoutCity.length === 0) {
            this.LOGGER.log(`checkSubdivisionTender - No tenders without city`);
            return messageTxt;
        }
        const listCities = await this.geoService.findAdmdivisionsByCountry('CL');
        const listSubdivisionDB = await this.geoService.findSubdivisionsByCountryCode('CL');
        this.LOGGER.log(`checkSubdivisionTender - listCities size: ${listCities.length}`);
        for (const tenderDetails of tendersWihoutCity) {
            const detail = tenderDetails.details;
            detail.JustificacionPublicidad = '';
            messageTxt = messageTxt.concat(`. Procesando licitación: ${tenderDetails.id} - ${tenderDetails.code}`);
            this.tenderRepository.updateSubdivision({
                id: tenderDetails.id,
                subdivisionId: await this.findSubdivision(listCities, detail, listSubdivisionDB)
            });
        }
        messageTxt = messageTxt.concat(`. Busqueda de ciudades en licitaciones finalizada.`);
        return messageTxt;
    }
    isPrime(num) {
        if (num < 2)
            return false;
        for (let i = 2; i <= Math.sqrt(num); i++) {
            if (num % i === 0)
                return false;
        }
        return true;
    }
    async checkCloseDate(applicationLogId) {
        const initTime = util_1.TenderUtil.getCurrentSystemDate().getTime();
        this.LOGGER.warn(`checkCloseDate - START`);
        const tendersWihoutCloseDate = await this.tenderRepository.findWithoutCloseDate();
        let messageTxt = `ApplicationLogId: ${applicationLogId} - Cantidad de Licitaciones sin fecha (Cierre) informada: ${tendersWihoutCloseDate.length}`;
        if (tendersWihoutCloseDate.length === 0) {
            this.LOGGER.log(`checkCloseDate - No tenders without city`);
            return messageTxt;
        }
        this.LOGGER.log(`checkCloseDate - listTenders size: ${tendersWihoutCloseDate.length}`);
        for (const tenderDetails of tendersWihoutCloseDate) {
            messageTxt = messageTxt.concat(`. Procesando licitación: ${tenderDetails.id} - ${tenderDetails.code}`);
            const detail = tenderDetails.details;
            detail.JustificacionPublicidad = '';
            this.tenderRepository.updateCloseDate({
                id: tenderDetails.id,
                closeDate: detail.Fechas.FechaCierre ? new Date(detail.Fechas.FechaCierre) : null
            });
        }
        this.LOGGER.warn(`checkCloseDate - END - time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
        return messageTxt;
    }
    async checkMetadataKeywords(applicationLogId) {
        const initTime = util_1.TenderUtil.getCurrentSystemDate().getTime();
        const listKeywordsToUpdate = await this.keywordService.getAllWithouthMetadata();
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Tamaño lista a actualizar Keywords: ${listKeywordsToUpdate.length}`;
        this.LOGGER.debug(`checkMetadataKeywords - listKeywordsToUpdate size: ${listKeywordsToUpdate.length}`);
        if (listKeywordsToUpdate.length === 0) {
            this.LOGGER.debug(`checkMetadataKeywords - No keywords without metadata`);
            return messageTxt;
        }
        for (const keyword of listKeywordsToUpdate) {
            this.LOGGER.debug(`checkMetadataKeywords - keyword: ${keyword.value}`);
            try {
                const metadata = await this.fetchRazorMetadata(keyword.value);
                await this.keywordService.updateMetadata(keyword.id, this.createResponseTenderMetadata(metadata));
                messageTxt = messageTxt.concat(`. Keyword ID: ${keyword.id} actualizado con éxito`);
            }
            catch (error) {
                this.LOGGER.error(`checkMetadataKeywords - Metadata Keyword id ${keyword.id} error: ${error}`);
                throw {
                    message: `Fallo al actualizar metadata de la keyword: ${keyword.id} - ${keyword.value}`,
                    error,
                };
            }
        }
        this.LOGGER.debug(`checkMetadataKeywords - time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
        return messageTxt;
    }
    async checkTenderWithCloseDate(applicationLogId) {
        const { end } = util_1.TenderUtil.getDayStartAndEnd(util_1.TenderUtil.getCurrentSystemDate());
        const listTenderToDelete = await this.tenderRepository.findByCloseDate(util_1.TenderUtil.subtractDays(end, 1));
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Cantidad de Licitaciones vencidas el día de ayer: ${listTenderToDelete.length}`;
        for (const tenderDetails of listTenderToDelete) {
            messageTxt = messageTxt.concat(`. Procesando licitación: ${tenderDetails.id} - ${tenderDetails.code}`);
            this.LOGGER.log(`logicalRemoveByCloseDate - tender to delete: ${tenderDetails.id}`);
            this.tenderRepository.logicalRemove(tenderDetails.id);
        }
        return messageTxt;
    }
    async tenderTaskPerMinutes() {
        const usage = process.memoryUsage();
        this.LOGGER.debug(`MEMORY IN USE: RSS=${usage.rss / 1024 / 1024} MB, HEAP=${usage.heapUsed / 1024 / 1024} MB`);
        this.reviewTendersInfo(enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG);
    }
    async createDashboardCompany(companyId, userId) {
        await this.searchTenderToUserCompanyWithSubdivision(companyId, userId);
        this.searchTendersDB({ companyId, userId }, true);
        await this.firebaseService.groupNotifications(userId);
    }
    async searchTenderToUserCompanyWithSubdivision(companyId, userId) {
        const listSubdivisionByCompany = await this.companyService.getSubdivisionsByCompanyId(companyId);
        const notificationsArray = [];
        for (const subdivision of listSubdivisionByCompany) {
            this.LOGGER.log(`searchTenderToUserCompany - subdivision: ${subdivision.name} to user: ${userId} company: ${companyId}`);
            const listTenderBySubdivision = await this.tenderRepository.findBySubdivisionId(subdivision.id, true);
            this.LOGGER.log(`searchTenderToUserCompany - subdivision: ${subdivision.id} 
        tenders: ${listTenderBySubdivision ? listTenderBySubdivision.length : 0}`);
            if (listTenderBySubdivision && listTenderBySubdivision.length > 0) {
                this.userCompanyTenderRepository.saveAll(userId, companyId, listTenderBySubdivision.map(tender => tender.id), `Cerca en ${subdivision.name}`);
                notificationsArray.push({
                    userId: userId,
                    title: `Encontradas por Ubicación`,
                    defaultMessage: (`Encontradas ${listTenderBySubdivision.length} licitaciones en ${subdivision.name}`.length > 255) ?
                        `Encontradas ${listTenderBySubdivision.length} licitaciones en ${subdivision.name}`.substring(0, 255) :
                        `Encontradas ${listTenderBySubdivision.length} licitaciones en ${subdivision.name}`,
                    active: true,
                    subdivisionId: subdivision.id,
                    amountGeo: listTenderBySubdivision.length,
                });
                this.LOGGER.warn(`Save success to user-company-tender user: ${userId} company: ${companyId} subdivision ${subdivision.id}`);
            }
        }
        notificationsArray.length > 0 && await this.notificationRecordService.saveAll(notificationsArray);
    }
    async reviewTenderWihoutMetadata(applicationLogId) {
        const listTenderMetadataToUpdate = await this.tenderRepository.getAllWithouthMetadata();
        this.LOGGER.log(`ReviewTendersInfo - listTenderMetadataToUpdate size: ${listTenderMetadataToUpdate.length}`);
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Licitaciones sin metadatos: ${listTenderMetadataToUpdate.length}`;
        let count = listTenderMetadataToUpdate.length;
        for (const tender of listTenderMetadataToUpdate) {
            messageTxt = messageTxt.concat(`. Procesando licitación: ${tender.id}`);
            this.LOGGER.log(`ReviewTendersInfo - tender: ${tender.id}`);
            count--;
            try {
                const metadata = await this.fetchRazorMetadata(this.createRequestTextTender(tender.description, tender.detail));
                await this.tenderRepository.updateMetadata(tender.id, this.createResponseTenderMetadata(metadata));
            }
            catch (error) {
                if (error.response.data.error.includes('You have reached your daily TextRazor request limit.')) {
                    messageTxt = messageTxt.concat(`. Limit_reached - ${count} tenders left to process`);
                    return messageTxt;
                }
                else {
                    messageTxt = messageTxt.concat(`. Error al procesar licitación: ${tender.id} - ${error.message}`);
                }
                this.LOGGER.error(`ReviewTendersInfo - Metadata Tender id ${tender.id} error: ${(0, util_2.inspect)(error)}`);
            }
        }
        return messageTxt;
    }
    async reviewTenderStatus(applicationLogId) {
        const { start, end } = util_1.TenderUtil.getDayStartAndEnd(new Date());
        this.LOGGER.log(`ReviewTendersInfo - start: ${start} end: ${end}`);
        const tenders = await this.tenderRepository.findByDatesUpset(start, end);
        this.LOGGER.log(`ReviewTendersInfo - tenders size: ${tenders.length}`);
        var messageTxt = `ApplicationLogId: ${applicationLogId} - Licitaciones a revisar si ha cambiado su estado: ${tenders.length}`;
        for (const tenderDetails of tenders) {
            const detail = tenderDetails.details;
            const isActive = this.evalStateTender(detail);
            this.tenderRepository.updateLogicalRemove({
                id: tenderDetails.id,
                state: isActive
            });
        }
        messageTxt = messageTxt.concat(`. Revisión de estado de licitaciones finalizada.`);
        return messageTxt;
    }
    async reviewTendersInfo(action) {
        this.LOGGER.warn(`ReviewTendersInfo - START - action: ${action}`);
        const initTime = util_1.TenderUtil.getCurrentSystemDate().getTime();
        this.LOGGER.warn(`ReviewTendersInfo - parcial time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
        if (action === enum_definition_1.ApplicationTypeEnum.TENDER_WITHOUT_META_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_WITHOUT_META_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_WITHOUT_META_LOG, applicationLogId, this.reviewTenderWihoutMetadata.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_COMPLETE_STATE_LOG, applicationLogId, this.reviewTenderStatus.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_CLOSE_DATE_LOG, applicationLogId, this.checkCloseDate.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_CHECK_SUBDIVISION_LOG, applicationLogId, this.checkTenderSubdivision.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.TENDER_DELETE_CLOSE_DATE_LOG, applicationLogId, this.checkTenderWithCloseDate.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.SUMMARY_ADMIN_LOG, applicationLogId, this.sendEmailSumaryToAdmin.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.KEYWORDS_LOG, applicationLogId, this.checkMetadataKeywords.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.CHECK_TENDER_FAVORITES_TO_CLOSE_LOG, applicationLogId, this.checkTenderFavoritesToClose.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.DAILY_EMAIL_SUMMARY_LOG, applicationLogId, this.firebaseService.sendDailyEmailSumary.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.CHECK_NEW_TENDERS_USER_LOG, applicationLogId, this.checkNewTendersUserCompany.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.RECALCULATE_TENDER_DASHBOARD_LOG, applicationLogId, this.recalculteTender.bind(this));
        }
        else if (action === enum_definition_1.ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG) {
            let applicationLogId = await this.createApplicationLogID(enum_definition_1.ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG);
            await this.logAndExecute(enum_definition_1.ApplicationTypeEnum.ERRASE_OLD_TENDERS_LOG, applicationLogId, this.erraseOldTenders.bind(this));
        }
        this.LOGGER.warn(`ReviewTendersInfo - tenders updated END - time ${util_1.TenderUtil.getCurrentSystemDate().getTime() - initTime} ms`);
    }
    createResponseTenderMetadata(metadata) {
        let responseMetadata = new domain_1.Metadata();
        this.LOGGER.log(`createResponseTenderMetadata - EVAL SENTENCES WORDS`);
        if (metadata.response.sentences) {
            responseMetadata.words = [];
            for (const sentence of metadata.response.sentences) {
                for (const word of sentence.words) {
                    responseMetadata.words.push(new domain_1.Word(word.position, word.startingPos, word.endingPos, word.stem, word.token, word.partOfSpeech));
                }
            }
        }
        this.LOGGER.log(`createResponseTenderMetadata - EVAL COURSE TOPISC`);
        if (metadata.response.coarseTopics) {
            responseMetadata.coarseTopics = [];
            for (const coarseTopic of metadata.response.coarseTopics) {
                responseMetadata.coarseTopics.push(new domain_1.CoarseTopics(coarseTopic.label, coarseTopic.score));
            }
        }
        this.LOGGER.log(`createResponseTenderMetadata - EVAL TOPICS`);
        if (metadata.response.topics) {
            responseMetadata.topics = [];
            for (const topic of metadata.response.topics) {
                responseMetadata.topics.push(new domain_1.Topics(topic.label, topic.score));
            }
        }
        this.LOGGER.log(`createResponseTenderMetadata - EVAL ENTITIES`);
        if (metadata.response.entities) {
            responseMetadata.entities = [];
            for (const entity of metadata.response.entities) {
                responseMetadata.entities.push(new domain_1.EntityInfo(entity.entityId, entity.type, entity.confidenceScore));
            }
        }
        return responseMetadata;
    }
    async sendEmailSumaryToAdmin(applicationLogId) {
        this.LOGGER.log(`sendEmailSumaryToAdmin - START`);
        return await this.firebaseService.sendEmailSumaryToAdmin(applicationLogId, this.userService);
    }
    createRequestTextTender(description, detail) {
        let out = description;
        for (const itemDetail of detail.Items.Listado) {
            if (itemDetail.Descripcion) {
                out = out + ' ' + itemDetail.Descripcion;
            }
            if (itemDetail.Categoria) {
                out = out + ' ' + itemDetail.Categoria;
            }
        }
        return out;
    }
    evalStateTender(detail) {
        return detail.Estado === 'Publicada' || detail.Estado === 'Desierta' || detail.Estado === 'Adjudicada';
    }
    async findSubdivision(listCities, detail, listSubdivisionDB) {
        let subdivisionId = null;
        let searchCity = detail.Comprador && detail.Comprador.ComunaUnidad;
        for (const city of listCities) {
            if (searchCity && this.normalizeString(searchCity.trim()) === this.normalizeString(city.name.trim())) {
                subdivisionId = city.subidivisionId;
                break;
            }
        }
        if (subdivisionId === null) {
            searchCity = detail.Comprador && detail.Comprador.RegionUnidad;
            for (const subdivision of listSubdivisionDB) {
                if (searchCity && this.normalizeString(searchCity.trim()) === this.normalizeString(subdivision.name.trim())) {
                    subdivisionId = subdivision.id;
                    break;
                }
            }
        }
        this.LOGGER.log(`findCity - subdivisionId: ${subdivisionId} - city: ${searchCity}`);
        return subdivisionId;
    }
    normalizeString(str) {
        return str
            .normalize("NFD")
            .replace(/[\u0300-\u036f]/g, "")
            .toLowerCase();
    }
    async getTenderByCode(code, userId) {
        const tender = await this.tenderRepository.findByCode(code);
        if (tender) {
            tender.labelAmount = util_1.TenderUtil.convertToMillions(tender.details.MontoEstimado || 0);
            tender.typeOfMoney = tender.details.Moneda;
            tender.labelLastUpdated = util_1.TenderUtil.calculateTime(tender.createdAt, tender.updatedAt);
            if (userId) {
                this.LOGGER.log(`SAVE INTO HISTORY_TENDER - code: ${code}, userId: ${userId} isFavorite: false`);
                this.userHistoryTenderService.saveHistoryTender(userId, tender.id);
            }
        }
        return tender;
    }
    async addTenderByCodeToCompany(code, companyId) {
        this.LOGGER.log(`addTenderByCodeToCompany - code: ${code}, companyId: ${companyId}`);
        const tenderMatch = await this.tenderRepository.findByCode(code);
        if (!tenderMatch) {
            this.LOGGER.warn(`addTenderByCodeToCompany - Tender not found for code: ${code}`);
            return 'Licitación no encontrada';
        }
        const company = await this.companyService.findById(companyId);
        if (!company) {
            this.LOGGER.warn(`addTenderByCodeToCompany - Company not found for companyId: ${companyId}`);
            return 'Empresa no encontrada';
        }
        const usersCompany = await this.userCompanyTenderRepository.getUsersIdsByCompanyId(companyId);
        const notificationsArray = [];
        for (const userId of usersCompany) {
            this.LOGGER.log(`addTenderByCodeToCompany - userId: ${userId} - code: ${code}`);
            this.userCompanyTenderRepository.save(userId, companyId, tenderMatch.id, `Licitación agregada por tu administrador.`, '');
            notificationsArray.push({
                userId: userId,
                title: `Coincidencias por palabras claves`,
                defaultMessage: `Creemos que esta licitación puede ser de tu interés`,
                active: true,
                monthFilterTender: null,
                amountWords: 0,
                amountGeo: 0
            });
        }
        notificationsArray.length > 0 && await this.notificationRecordService.saveAll(notificationsArray);
        return 'estado';
    }
    async generateInfoDashboard(user, companyId) {
        let output = new domain_1.DashboardTO();
        let listDetail = [];
        let amount = 0;
        const company = await this.companyService.findById(companyId);
        let amountFavorites = 0;
        let countFavorites = 0;
        if (company) {
            const tenderListByCompany = await this.userCompanyTenderRepository.findTenderByUserCompanyId(user.id, company.id);
            amount += tenderListByCompany.length;
            tenderListByCompany.forEach((tender) => {
                countFavorites = tender.isFavorite ? countFavorites + 1 : countFavorites;
                amountFavorites = tender.isFavorite ? amountFavorites + tender.details.MontoEstimado || 0 : amountFavorites;
                if (!tender.isFavorite) {
                    const existingDetail = listDetail.find(detail => detail.description === tender.source);
                    if (existingDetail) {
                        existingDetail.amountPerSubdivision += tender.details.MontoEstimado || 0;
                        existingDetail.labelAmount = `${existingDetail.amountPerSubdivision} (${++existingDetail.count} coincidencias)`;
                    }
                    else {
                        listDetail.push({
                            subdivisionId: tender.subdivisionId || null,
                            description: tender.source,
                            amountPerSubdivision: tender.details.MontoEstimado || 0,
                            labelAmount: `${tender.details.MontoEstimado || 0} (1 coincidencia)`,
                            count: 1,
                        });
                    }
                }
            });
            if (countFavorites > 0) {
                listDetail.push({
                    description: 'Mis favoritos',
                    amountPerSubdivision: amountFavorites,
                    labelAmount: `${countFavorites} ${countFavorites == 1 ? 'en seguimiento' : 'en seguimiento'}`,
                });
            }
        }
        output.userAmount = await this.userCompanyService.countUserByCompany(companyId);
        output.tenderTotalAmount = await this.tenderRepository.countActiveTenders();
        output.newTenderAmount = (amount - countFavorites < 0) ? 0 : amount - countFavorites;
        output.listDetails = listDetail.map((detail) => {
            if (detail.description === 'Mis favoritos') {
                return detail;
            }
            return {
                description: detail.description,
                amountPerSubdivision: detail.amountPerSubdivision,
                subdivisionId: detail.subdivisionId,
                labelAmount: util_1.TenderUtil.convertToMillions(detail.amountPerSubdivision) + ` (${detail.count} ${detail.count == 1 ? 'coincidencia' : 'coincidencias'})`,
                dateFilterTender: util_1.TenderUtil.evalMonth(detail.description),
            };
        });
        return output;
    }
    async getPaginatedTenders(userId, companyId, page, pageSize, searchType, subdivisionId, monthRequest) {
        this.LOGGER.log(`GET PAGINATED TENDERS - userId: ${userId}, companyId: ${companyId}, page: ${page}, pageSize: ${pageSize}, searchType: ${searchType}, subdivisionId: ${subdivisionId} monthRequest: ${monthRequest}`);
        return (await this.userCompanyTenderRepository.getPaginatedTenders(userId, companyId, page, pageSize, searchType, subdivisionId, monthRequest)).map((tender) => {
            tender.labelAmount = util_1.TenderUtil.convertToMillions(tender.details.MontoEstimado || 0);
            tender.typeOfMoney = tender.labelAmount === '0' ? `${tender.details.Moneda} - ${tender.details.Tipo}` : tender.details.Moneda;
            tender.labelLastUpdated = util_1.TenderUtil.calculateTime(tender.createdAt, tender.updatedAt);
            const closeTender = util_1.TenderUtil.calculateTimeFromDateString(tender.details.Fechas.FechaCierre);
            const dateInfo = closeTender.length > 0 ? `Fecha de cierre: ${tender.details.Fechas.FechaCierre?.substring(0, 16).replace('T', ' ')} ${closeTender === 'Finalizado' ? '' : '\n (' + closeTender}) ` : 'Fecha de cierre no informada';
            const publishDate = util_1.TenderUtil.calculateTimeFromDateString(tender.details.Fechas.FechaPublicacion);
            const datePublishInfo = publishDate.length > 0 ? `\n Fecha de publicación: ${tender.details.Fechas.FechaPublicacion?.substring(0, 16).replace('T', ' ')}` : 'Fecha de publicación no informada';
            tender.labelCloseTender = dateInfo + datePublishInfo + ' \n Estado: ' + tender.details.Estado;
            return tender;
        });
    }
    async getPaginatedHistoryTenders(userId, page, pageSize) {
        const resultPaginated = await this.userCompanyTenderRepository.getPaginatedHistoryTenders(userId, page, pageSize);
        const detailsTender = await this.tenderRepository.findInfohistoryTender(resultPaginated.map(tender => tender.id));
        this.LOGGER.log('size resultPaginated: ' + resultPaginated.length + ' - detailsTender: ' + detailsTender.length);
        return resultPaginated.map((tender) => {
            if (!tender.isErrased) {
                const detailTender = detailsTender.find(detail => detail.tenderId === tender.id);
                if (detailTender) {
                    tender.code = detailTender.code;
                    tender.name = `${detailTender.code} - ${detailTender.details.Nombre.toUpperCase() || ''}`;
                    tender.description = detailTender.details.Descripcion || '';
                    tender.labelAmount = util_1.TenderUtil.convertToMillions(detailTender.details.MontoEstimado || 0);
                    tender.typeOfMoney = tender.labelAmount === '0' ? `${detailTender.details.Moneda} - ${detailTender.details.Tipo}` : detailTender.details.Moneda;
                    tender.labelLastUpdated = util_1.TenderUtil.calculateTime(detailTender.createdAt, detailTender.updatedAt);
                    const closeTender = util_1.TenderUtil.calculateTimeFromDateString(detailTender.details.Fechas.FechaCierre);
                    const dateInfo = closeTender.length > 0 ? `Fecha de cierre: ${detailTender.details.Fechas.FechaCierre?.substring(0, 16).replace('T', ' ')} ${closeTender === 'Finalizado' ? '' : '\n (' + closeTender}) ` : 'Fecha de cierre no informada';
                    const publishDate = util_1.TenderUtil.calculateTimeFromDateString(detailTender.details.Fechas.FechaPublicacion);
                    const datePublishInfo = publishDate.length > 0 ? `\n Fecha de publicación: ${detailTender.details.Fechas.FechaPublicacion?.substring(0, 16).replace('T', ' ')}` : 'Fecha de publicación no informada';
                    tender.labelCloseTender = dateInfo + datePublishInfo + ' \n Estado: ' + detailTender.details.Estado;
                }
            }
            return tender;
        });
    }
    async searchTendersDB(params, waitMinutes = false) {
        this.LOGGER.log(`SEARCH TENDERS waitMinutes: ${waitMinutes}`);
        if (waitMinutes) {
            await new Promise(resolve => setTimeout(resolve, 1000 * 60 * 2));
        }
        this.LOGGER.log(`SEARCH TENDERS - START`);
        const keywordsCompany = await this.keywordService.findByCompanyId(params.companyId, true);
        const outListKeywordsCompany = [];
        keywordsCompany.forEach(keyword => {
            const { wordsList, topicsList, coarseTopicsList } = this.getListOfWordsMetada(keyword.metadata);
            outListKeywordsCompany.push(...wordsList.map(word => word.stem));
            outListKeywordsCompany.push(...topicsList.map(topic => topic.label));
            outListKeywordsCompany.push(...coarseTopicsList.map(coarseTopic => coarseTopic.label));
        });
        if (keywordsCompany.length === 0) {
            this.LOGGER.warn(`SEARCH TENDERS - No keywords found for company ${params.companyId}`);
            return 'false';
        }
        for (var month = 2; month >= 0; month--) {
            const listMatchedTenders = [];
            const { start, end } = util_1.TenderUtil.getMonthStartAndEnd(new Date(), -month);
            const tenders = await this.tenderRepository.findByDates(start, end);
            this.LOGGER.log(`SEARCH TENDERS - tenders size: ${tenders.length} form Date ${start} to ${end}`);
            for (const tender of tenders) {
                const { wordsList, topicsList, coarseTopicsList } = this.getListOfWordsMetada(tender.metadata);
                const findMatchCoarseTopic = this.matchWordsService.findMatches(outListKeywordsCompany, coarseTopicsList.map(coarseTopic => coarseTopic.label));
                const findMatchTopics = this.matchWordsService.findMatches(outListKeywordsCompany, topicsList.map(topic => topic.label));
                const findMatchWords = this.matchWordsService.findMatches(outListKeywordsCompany, wordsList.map(word => word.stem));
                const havematchList = this.evalResultsMatch(tender.id, findMatchTopics, findMatchWords, findMatchCoarseTopic);
                if (havematchList.length > 5) {
                    tender.matchResult = JSON.stringify({ keywordsOrigin: outListKeywordsCompany, havematchList });
                    listMatchedTenders.push(tender);
                }
            }
            if (listMatchedTenders.length > 0) {
                for (const tenderMatch of listMatchedTenders) {
                    this.LOGGER.log(`SAVING TENDERS ${tenderMatch.id} for user ${params.userId} and company ${params.companyId}`);
                    this.userCompanyTenderRepository.save(params.userId, params.companyId, tenderMatch.id, `Coincidencias por palabras claves ${start.toLocaleString('es-CL', { month: 'long' })} ${start.getFullYear()}`, tenderMatch.matchResult);
                }
                const notificationsArray = [];
                notificationsArray.push({
                    userId: params.userId,
                    title: `Coincidencias por palabras claves`,
                    defaultMessage: `Licitaciones encontrada en ${start.toLocaleString('es-CL', { month: 'long' })} ${start.getFullYear()}`,
                    active: true,
                    monthFilterTender: start,
                    amountWords: listMatchedTenders.length,
                    amountGeo: 0
                });
                notificationsArray.length > 0 && await this.notificationRecordService.saveAll(notificationsArray);
            }
        }
        await this.firebaseService.groupNotifications(params.userId);
        this.LOGGER.warn(`SEARCH TENDERS - END`);
        return 'true';
    }
    evalResultsMatch(tenderId, findMatchTopics, findMatchWords, findMatchCoarseTopic) {
        const listWithMatch = [];
        findMatchTopics.forEach((result) => {
            if (result.matches.length > 0) {
                listWithMatch.push(result.item.toLowerCase());
            }
        });
        return [...new Set(listWithMatch)];
    }
    getListOfWordsMetada(json) {
        let wordsList = [];
        if (json.words) {
            wordsList = json.words.filter((word) => word.partOfSpeech === 'NOUN' || word.partOfSpeech === 'ADJ');
        }
        let topicsList = [];
        if (json.topics) {
            topicsList = json.topics.filter((topic) => topic.score > 0.6);
        }
        let coarseTopicsList = [];
        if (json.coarseTopics) {
            coarseTopicsList = json.coarseTopics.filter((coarseTopic) => coarseTopic.score > 1);
        }
        return {
            wordsList,
            topicsList,
            coarseTopicsList
        };
    }
    async fetchRazorMetadata(textToEval) {
        this.LOGGER.log(`Fetching metadata for text: ${textToEval}`);
        const delay = (ms) => new Promise((resolve) => setTimeout(resolve, ms));
        for (let attempt = 1; attempt <= this.maxTextRetries; attempt++) {
            try {
                const formData = new URLSearchParams();
                formData.append('text', textToEval);
                formData.append('extractors', 'entities,topics,entailments');
                const response = await (0, rxjs_1.firstValueFrom)(this.httpService.post(this.textApiUrl, formData, {
                    headers: {
                        'x-textrazor-key': this.textApiKey,
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                }));
                return response.data;
            }
            catch (error) {
                if (attempt === Number(this.maxTextRetries)) {
                    this.LOGGER.debug(`Failed to fetch tender details for args: ${JSON.stringify(textToEval)}`);
                    throw error;
                }
                this.LOGGER.debug(`Attempt ${attempt} failed. Retrying in ${attempt * 5}ms...`);
                await delay(attempt * 5);
            }
        }
    }
    async recalculteTender(applicationLogId) {
        this.LOGGER.log('recalculateTender - START');
        const companyIds = await this.companyService.getCompanyIdsToRecalculateTender();
        this.LOGGER.log(`recalculateTender - companyIds size: ${companyIds.length}`);
        let messageTxt = `Recalculating tenders for ${companyIds.length} companies`;
        await this.applicationLogService.updateState(applicationLogId, 8, messageTxt);
        for (const companyId of companyIds) {
            this.LOGGER.log(`recalculateTender - applicationLogId: ${applicationLogId} - errase actual tenders - companyId: ${companyId}`);
            messageTxt = messageTxt.concat('. Errase tender to companyId: ' + companyId);
            this.userCompanyTenderRepository.erraseJoinCompanyTender(companyId);
            this.LOGGER.log(`recalculateTender - applicationLogId: ${applicationLogId} - search new tenders dashboard - companyId: ${companyId}`);
            const activeUserIds = await this.userCompanyService.getUserIdsWithActiveCompany();
            messageTxt = messageTxt.concat('. Loading new tenders to companyId: ' + companyId + ' and users: ' + activeUserIds.length);
            for (const userId of activeUserIds) {
                this.LOGGER.log(`recalculateTender - applicationLogId: ${applicationLogId} - create dashboard for userId: ${userId} companyId: ${companyId}`);
                this.createDashboardCompany(companyId, userId);
            }
            this.companyService.updateCheckTenders(companyId, true);
        }
        return messageTxt;
    }
    async paginationByCompanyAdmin(page, pageSize) {
        this.LOGGER.log(`Paginating companies by admin, page: ${page}, pageSize: ${pageSize}`);
        const companies = await this.companyService.paginationByCompanyAdmin(page, pageSize);
        for (const company of companies) {
            const userInfo = await this.userCompanyService.getInfoUserCompany(company.companyId);
            company.listUsers = userInfo;
            company.amountTenders = await this.userCompanyTenderRepository.countActiveTendersCompany(company.companyId);
        }
        return companies;
    }
};
exports.TenderServiceImpl = TenderServiceImpl;
exports.TenderServiceImpl = TenderServiceImpl = TenderServiceImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)('TenderRepository')),
    __param(1, (0, common_1.Inject)('CompanyService')),
    __param(2, (0, common_1.Inject)('HistoryTenderService')),
    __param(3, (0, common_1.Inject)('MatchWordsService')),
    __param(4, (0, common_1.Inject)('UserCompanyTenderService')),
    __param(5, (0, common_1.Inject)('NotificationRecordService')),
    __param(6, (0, common_1.Inject)('GeoService')),
    __param(9, (0, common_1.Inject)('FirebaseService')),
    __param(10, (0, common_1.Inject)('KeywordService')),
    __param(11, (0, common_1.Inject)('UserService')),
    __param(12, (0, common_1.Inject)('ApplicationLogService')),
    __param(13, (0, common_1.Inject)('UserCompanyService')),
    __param(14, (0, common_1.Inject)('UserRequestService')),
    __metadata("design:paramtypes", [Object, Object, Object, Object, Object, Object, Object, config_1.ConfigService,
        axios_1.HttpService, Object, Object, Object, Object, Object, Object])
], TenderServiceImpl);
//# sourceMappingURL=tender-service-impl.js.map