import { ConfigService } from '@nestjs/config';
import { LicitacionesQueryParams, LicitacionesResponse } from 'src/licitaapp/application';
import { MercadoPublicoRepository } from 'src/licitaapp/application/mercado-publico/mp.repository';
import { ApplicationLogService } from 'src/licitaapp/application/service/application-log-service/application-log-service.interface';
import { TenderFetcherService } from 'src/licitaapp/application/service/tender-fetcher-service/tender-fetcher-service.interface';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
export declare class TenderFetcherServiceImpl implements TenderFetcherService {
    private readonly configService;
    private readonly mercadoPublicoAPI;
    private readonly tenderService;
    private readonly applicationLogService;
    private readonly LOGGER;
    static readonly TIMEZONE = "America/Santiago";
    private readonly maxRetries;
    private readonly retryInterval;
    private readonly fetchFromDaysAgo;
    private readonly enabled;
    constructor(configService: ConfigService, mercadoPublicoAPI: MercadoPublicoRepository, tenderService: TenderService, applicationLogService: ApplicationLogService);
    fetchTendersWithRetry(args: LicitacionesQueryParams): Promise<LicitacionesResponse | undefined>;
    processTenders(args: LicitacionesQueryParams): Promise<boolean>;
    fetchTendersOfTheDay(): Promise<boolean | undefined>;
    syncTenders(): Promise<void>;
}
