import { Subdivision } from 'src/framework/domain/entities/subdivision.entity';
import { DBConfigService } from 'src/framework/infrastructure/drizzle';
import { UserCompanyService, CompanyRepository, CompanyService, KeywordService } from 'src/licitaapp';
import { UserCompanyTenderService } from 'src/licitaapp/application/service/user-company-tender-service/user-company-tender-service.interface';
import { Company, CompanyFullTO, CompanyRegisterTO, Keyword } from 'src/licitaapp/domain';
import { CompanyUserTO } from 'src/licitaapp/domain/dto/company.user.to';
export declare class CompanyServiceImpl implements CompanyService {
    private readonly companyRepository;
    private readonly userCompanyService;
    private readonly keywordService;
    private readonly userCompanyTenderService;
    private readonly db;
    private readonly LOGGER;
    constructor(companyRepository: CompanyRepository, userCompanyService: UserCompanyService, keywordService: KeywordService, userCompanyTenderService: UserCompanyTenderService, db: DBConfigService);
    deleteByUserCompany(userId: number, companyId: number): Promise<void>;
    paginationByCompanyAdmin(page: number, pageSize: number): Promise<CompanyUserTO[]>;
    getCompanyIdsToRecalculateTender(): Promise<number[]>;
    getSubdivisionsByCompanyId(companyId: number): Promise<Subdivision[]>;
    updateCheckTenders(companyId: number, checkTender: boolean): Promise<boolean>;
    getAllWithouthMetadata(): Promise<Keyword[]>;
    updateCompany(companyId: number, userId: number, updateCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    createCompany(userId: number, insertCompany: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    findByDNI(dni: string): Promise<Company | null>;
    findById(id: number): Promise<Company | null>;
    findByIdWithFetch(id: number): Promise<CompanyFullTO | null>;
}
