import { TxType } from 'src/framework';
import { ApplicationLogRepository } from 'src/licitaapp/application/repository/application-log-repository/application-log-repository.interface';
import { ApplicationLogService } from 'src/licitaapp/application/service/application-log-service/application-log-service.interface';
import { ApplicationLog, InsertApplicationLog } from 'src/licitaapp/domain';
import { ApplicationTypeEnum } from 'src/licitaapp/domain/enum/enum.definition';
export declare class ApplicationLogServiceImpl implements ApplicationLogService {
    private readonly applicationLogRepository;
    private readonly LOGGER;
    constructor(applicationLogRepository: ApplicationLogRepository);
    save(applicationLog: InsertApplicationLog, tx?: TxType): Promise<number>;
    updateState(applicationLogId: number, statusTypeId: number, detail: string, tx?: TxType): Promise<boolean>;
    logicalRemove(applicationLogId: number, tx?: TxType): Promise<boolean>;
    getAllPaginated(page: number, pageSize: number, type?: ApplicationTypeEnum): Promise<ApplicationLog[]>;
}
