"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TenderRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_1 = require("../../../../framework/infrastructure/drizzle");
const domain_1 = require("../../../domain");
const util_1 = require("../../../domain/util");
let TenderRepositoryImpl = TenderRepositoryImpl_1 = class TenderRepositoryImpl {
    constructor(db, configService) {
        this.db = db;
        this.configService = configService;
        this.LOGGER = new framework_1.PrimeLogger(TenderRepositoryImpl_1.name);
        this.limitGeoTendersDashboard = this.configService.get('LIMIT_GEO_TENDERS_DASHBOARD', 5);
    }
    async findInfohistoryTender(tenderId) {
        this.LOGGER.log(`findInfohistoryTender Tender IDs: ${tenderId.filter(id => id != 0)}`);
        if (tenderId.length === 0) {
            return [];
        }
        const selectFields = {
            tenderId: framework_1.schema.tenderTable.id,
            code: framework_1.schema.tenderTable.code,
            name: framework_1.schema.tenderTable.name,
            description: framework_1.schema.tenderTable.description,
            details: framework_1.schema.tenderTable.details,
            createdAt: framework_1.schema.tenderTable.createdAt,
            updatedAt: framework_1.schema.tenderTable.updatedAt,
        };
        return await (this.db.conn)
            .select(selectFields)
            .from(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.tenderTable.id, tenderId.filter(id => id != 0)))
            .then((rows) => {
            if (rows.length === 0) {
                return [];
            }
            return rows.map((row) => {
                return {
                    tenderId: row.tenderId,
                    code: row.code,
                    name: row.name,
                    description: row.description,
                    details: row.details,
                    createdAt: row.createdAt,
                    updatedAt: row.updatedAt,
                };
            });
        });
    }
    async erraseByListId(tenderIds) {
        this.LOGGER.log(`erraseByListId Tender IDs: ${tenderIds}`);
        await this.db.conn
            .delete(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.inArray)(framework_1.schema.tenderTable.id, tenderIds)).execute();
    }
    async findByCode(code) {
        return await this.selectTenderQuery()
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.code, code), (0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return undefined;
            }
            return this.mapRowToTender(rows[0]);
        });
    }
    async logicalRemove(tenderId) {
        this.LOGGER.log(`logicalRemove Tender: ${tenderId}`);
        await (this.db.conn)
            .update(framework_1.schema.tenderTable)
            .set({
            active: false,
            deletedAt: util_1.TenderUtil.getCurrentSystemDate(),
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tenderId));
    }
    async getAllWithouthMetadata(tx) {
        this.LOGGER.log(`getAllWithouthMetadata`);
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.tenderTable.id,
            description: framework_1.schema.tenderTable.description,
            detail: framework_1.schema.tenderTable.details,
        })
            .from(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true), (0, drizzle_orm_1.isNull)(framework_1.schema.tenderTable.metadata)))
            .then((rows) => {
            return rows.map((row) => ({
                id: row.id,
                description: row.description,
                detail: row.detail
            }));
        });
    }
    async updateMetadata(tenderId, metadata) {
        this.LOGGER.log(`updateMetadata Tender: ${tenderId}`);
        await (this.db.conn)
            .update(framework_1.schema.tenderTable)
            .set({
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            metadata: metadata,
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tenderId));
    }
    async findByDates(initDate, endDate) {
        this.LOGGER.log(`findByDates - initDate: ${initDate} endDate: ${endDate}`);
        var listTender = [];
        await this.db.conn.execute(`SELECT id, code, name, description, metadata FROM tender WHERE created_at BETWEEN '${initDate.toISOString().slice(0, 19).replace("T", " ")}' AND '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true AND metadata IS NOT NULL`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                const newTender = new domain_1.RequestTender();
                newTender.id = item.id;
                newTender.code = item.code;
                newTender.name = item.name;
                newTender.description = item.description;
                newTender.metadata = item.metadata;
                return newTender;
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findByDates: ${err}`);
        });
        return listTender;
    }
    async findWithoutCloseDate() {
        this.LOGGER.log(`findWithoutCloseDate`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE close_date IS NULL`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findWithoutCloseDate: ${err}`);
        });
        return listTender;
    }
    async findWithoutSubdivision() {
        this.LOGGER.log(`findWithoutCity`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE subdivision_id IS NULL`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findWithoutCity: ${err}`);
        });
        return listTender;
    }
    async findByCloseDate(endDate) {
        this.LOGGER.log(`findByCloaseDate - endDate: ${endDate}`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE close_date <= '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findByCloseDate: ${err}`);
        });
        return listTender;
    }
    async findByDatesUpset(initDate, endDate) {
        this.LOGGER.log(`findByDates - initDate: ${initDate.toISOString().slice(0, 19).replace("T", " ")} endDate: ${endDate.toISOString().slice(0, 19).replace("T", " ")}`);
        var listTender = [];
        await this.db.conn.execute(`SELECT * FROM tender WHERE created_at BETWEEN '${initDate.toISOString().slice(0, 19).replace("T", " ")}' AND '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true OR 
      updated_at BETWEEN '${initDate.toISOString().slice(0, 19).replace("T", " ")}' AND '${endDate.toISOString().slice(0, 19).replace("T", " ")}' AND active = true`).then((rows) => {
            const items = rows[0];
            listTender = items.map((item) => {
                return this.mapRowToTender(item);
            });
        })
            .catch((err) => {
            this.LOGGER.error(`Error findByDates: ${err}`);
        });
        return listTender;
    }
    async findById(id) {
        return await this.selectTenderQuery()
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, id), (0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)))
            .then((rows) => {
            if (rows.length === 0) {
                return undefined;
            }
            return this.mapRowToTender(rows[0]);
        });
    }
    async findBySubdivisionId(subdivisionId, withLimit = false) {
        try {
            const query = this.selectTenderQuery()
                .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.subdivisionId, subdivisionId), (0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)));
            if (withLimit) {
                query.limit(Number(this.limitGeoTendersDashboard));
            }
            query.orderBy((0, drizzle_orm_1.desc)(framework_1.schema.tenderTable.createdAt));
            const rows = await query;
            return rows.map((item) => this.mapRowToTender(item));
        }
        catch (err) {
            this.LOGGER.error(`Error findBySubdivisionId: ${err}`);
            return [];
        }
    }
    async upsert(tender) {
        const validatedTender = framework_1.schema.tenderTableInsertSchema.parse({
            code: tender.code,
            name: tender.name,
            description: tender.description,
            details: tender.details,
            subdivisionId: tender.subdivisionId,
        });
        const insertedTenderId = await this.db.conn
            .insert(framework_1.schema.tenderTable)
            .values({
            code: validatedTender.code,
            name: validatedTender.name,
            description: validatedTender.description,
            subdivisionId: validatedTender.subdivisionId,
            details: tender.details,
        })
            .onDuplicateKeyUpdate({
            set: {
                code: validatedTender.code,
                name: validatedTender.name,
                description: validatedTender.description,
                subdivisionId: validatedTender.subdivisionId,
                details: tender.details,
                updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            },
        })
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return insertedTenderId;
    }
    async countActiveTenders() {
        this.LOGGER.log(`countActiveTenders`);
        return await this.db.conn
            .select({ count: (0, drizzle_orm_1.count)() })
            .from(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, true)))
            .then((rows) => {
            return rows[0].count;
        });
    }
    async getLogicalRemoveTenderIds() {
        this.LOGGER.log(`getLogicalRemoveTenderIds`);
        return await this.db.conn
            .select({ id: framework_1.schema.tenderTable.id, code: framework_1.schema.tenderTable.code, details: framework_1.schema.tenderTable.details, description: framework_1.schema.tenderTable.description })
            .from(framework_1.schema.tenderTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.active, false))
            .then((rows) => {
            return rows.map((row) => new domain_1.TenderTO(row.id, row.code, row.details, row.description));
        });
    }
    async updateField(tender) {
        await this.db.conn
            .update(framework_1.schema.tenderTable)
            .set({
            active: tender.active,
            subdivisionId: tender.subdivisionId,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            details: tender.detail,
            deletedAt: tender.active ? null : util_1.TenderUtil.getCurrentSystemDate(),
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
            .execute();
    }
    async updateCloseDate(tender) {
        await this.db.conn
            .update(framework_1.schema.tenderTable)
            .set({
            closeDate: tender.closeDate,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate()
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
            .execute();
    }
    async updateLogicalRemove(tender) {
        if (!tender.state) {
            await this.db.conn
                .update(framework_1.schema.tenderTable)
                .set({
                active: tender.state,
                deletedAt: util_1.TenderUtil.getCurrentSystemDate()
            })
                .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
                .execute();
        }
    }
    async updateSubdivision(tender) {
        await this.db.conn
            .update(framework_1.schema.tenderTable)
            .set({
            subdivisionId: tender.subdivisionId,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate()
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.tenderTable.id, tender.id))
            .execute();
    }
    selectTenderQuery() {
        return this.db.conn
            .select({
            id: framework_1.schema.tenderTable.id,
            code: framework_1.schema.tenderTable.code,
            name: framework_1.schema.tenderTable.name,
            description: framework_1.schema.tenderTable.description,
            details: framework_1.schema.tenderTable.details,
            createdAt: framework_1.schema.tenderTable.createdAt,
            updatedAt: framework_1.schema.tenderTable.updatedAt,
            closeDate: framework_1.schema.tenderTable.closeDate,
        })
            .from(framework_1.schema.tenderTable)
            .$dynamic();
    }
    mapRowToTender(row) {
        return new domain_1.Tender(row.id, row.code, row.name, row.description, row.details, row.createdAt, row.updatedAt, row.closeDate, false, row.subdivisionId ? row.subdivisionId : undefined);
    }
};
exports.TenderRepositoryImpl = TenderRepositoryImpl;
exports.TenderRepositoryImpl = TenderRepositoryImpl = TenderRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_1.DBConfigService,
        config_1.ConfigService])
], TenderRepositoryImpl);
//# sourceMappingURL=tender-repository-impl.js.map