import { ConfigService } from '@nestjs/config';
import { DBConfigService, TxType } from 'src/framework/infrastructure/drizzle';
import { TenderRepository, Licitacion } from 'src/licitaapp';
import { InsertTender, Metadata, RequestTender, Tender, TenderHistoryTO, TenderTO } from 'src/licitaapp/domain';
export declare class TenderRepositoryImpl implements TenderRepository {
    private readonly db;
    private readonly configService;
    private readonly LOGGER;
    private readonly limitGeoTendersDashboard;
    constructor(db: DBConfigService, configService: ConfigService);
    findInfohistoryTender(tenderId: number[]): Promise<TenderHistoryTO[]>;
    erraseByListId(tenderIds: number[]): Promise<void>;
    findByCode(code: string): Promise<Tender | undefined>;
    logicalRemove(tenderId: number): Promise<void>;
    getAllWithouthMetadata(tx?: TxType): Promise<{
        id: number;
        description: string;
        detail: import("src/licitaapp/domain").Licitacion;
    }[]>;
    updateMetadata(tenderId: number, metadata: Metadata): Promise<void>;
    findByDates(initDate: Date, endDate: Date): Promise<RequestTender[]>;
    findWithoutCloseDate(): Promise<Tender[]>;
    findWithoutSubdivision(): Promise<Tender[]>;
    findByCloseDate(endDate: Date): Promise<Tender[]>;
    findByDatesUpset(initDate: Date, endDate: Date): Promise<Tender[]>;
    findById(id: number): Promise<Tender | undefined>;
    findBySubdivisionId(subdivisionId: number, withLimit?: boolean): Promise<Tender[]>;
    upsert(tender: InsertTender): Promise<number>;
    countActiveTenders(): Promise<number>;
    getLogicalRemoveTenderIds(): Promise<TenderTO[]>;
    updateField(tender: {
        id: number;
        active: boolean;
        detail?: Licitacion;
        subdivisionId?: number | null;
    }): Promise<void>;
    updateCloseDate(tender: {
        id: number;
        closeDate: Date | null;
    }): Promise<void>;
    updateLogicalRemove(tender: {
        id: number;
        state: boolean;
    }): Promise<void>;
    updateSubdivision(tender: {
        id: number;
        subdivisionId?: number | null;
    }): Promise<void>;
    private selectTenderQuery;
    private mapRowToTender;
}
