"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var KeywordRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeywordRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const drizzle_orm_1 = require("drizzle-orm");
const framework_1 = require("../../../../framework");
const drizzle_1 = require("../../../../framework/infrastructure/drizzle");
const domain_1 = require("../../../domain");
const util_1 = require("../../../domain/util");
let KeywordRepositoryImpl = KeywordRepositoryImpl_1 = class KeywordRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(KeywordRepositoryImpl_1.name);
    }
    async getAllWithouthMetadata(tx) {
        this.LOGGER.log(`getAllWithouthMetadata`);
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
            value: framework_1.schema.keywordTable.value,
            origin: framework_1.schema.keywordTable.origin,
        })
            .from(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.active, true), (0, drizzle_orm_1.isNull)(framework_1.schema.keywordTable.metadata)))
            .then((rows) => {
            return rows.map((row) => new domain_1.Keyword(row.id, row.value, row.origin));
        });
    }
    async findByCompanyId(companyId, isNullMetadata, tx) {
        const baseWhereClause = (0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.companyId, companyId), (0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.active, true));
        const metadataClause = isNullMetadata && (0, drizzle_orm_1.isNotNull)(framework_1.schema.keywordTable.metadata);
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
            value: framework_1.schema.keywordTable.value,
            origin: framework_1.schema.keywordTable.origin,
            metadata: framework_1.schema.keywordTable.metadata,
        })
            .from(framework_1.schema.keywordTable)
            .where(metadataClause ? (0, drizzle_orm_1.and)(baseWhereClause, metadataClause) : (0, drizzle_orm_1.and)(baseWhereClause))
            .then((rows) => {
            return rows.map((row) => new domain_1.Keyword(row.id, row.value, row.origin, undefined, undefined, row.metadata));
        });
    }
    async save(keyword, userId, tx) {
        const validatedKeyword = framework_1.schema.keywordTableInsertSchema.parse({
            value: keyword.value,
            origin: keyword.origin,
            active: true,
            userId: userId,
            companyId: keyword.companyId,
        });
        await (tx || this.db.conn).execute(drizzle_orm_1.sql.raw(`INSERT INTO keyword (active, value, origin, company_id, user_id) VALUES 
          (true, ${keyword.value}, ${keyword.origin}, ${keyword.companyId},${userId});`))
            .catch((err) => {
            this.LOGGER.error(`Error fetching registered users: ${err}`);
            throw new Error(`Error fetching registered users: ${err}`);
        });
        return new domain_1.Keyword(0, validatedKeyword.value, validatedKeyword.origin, undefined, undefined, undefined);
    }
    async saveAll(keywords, userId, tx) {
        return [];
    }
    async updateMetadata(keywordId, metadata) {
        this.LOGGER.log(`updateMetadata keyword: ${keywordId}`);
        await (this.db.conn)
            .update(framework_1.schema.keywordTable)
            .set({
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            metadata: metadata,
        })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.id, keywordId));
    }
    async findById(id, tx) {
        return await (tx || this.db.conn)
            .select({
            id: framework_1.schema.keywordTable.id,
            value: framework_1.schema.keywordTable.value,
            origin: framework_1.schema.keywordTable.origin,
        })
            .from(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.id, id))
            .then((rows) => {
            if (rows.length === 0) {
                return null;
            }
            return new domain_1.Keyword(rows[0].id, rows[0].value, rows[0].origin);
        });
    }
    async logicalRemove(id, tx) {
        this.LOGGER.log(`logicalRemove keyword: ${id}`);
        await (tx || this.db.conn)
            .update(framework_1.schema.keywordTable)
            .set({ active: false, deletedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.id, id));
    }
    async deleteByCompanyId(companyId, tx) {
        this.LOGGER.log(`deleteByCompanyId keyword: ${companyId}`);
        await (tx || this.db.conn)
            .delete(framework_1.schema.keywordTable)
            .where((0, drizzle_orm_1.eq)(framework_1.schema.keywordTable.companyId, companyId));
    }
};
exports.KeywordRepositoryImpl = KeywordRepositoryImpl;
exports.KeywordRepositoryImpl = KeywordRepositoryImpl = KeywordRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [drizzle_1.DBConfigService])
], KeywordRepositoryImpl);
//# sourceMappingURL=keyword-repository-impl.js.map