import { TxType } from 'src/framework';
import { KeywordRepository } from 'src/licitaapp/application';
import { DBConfigService } from 'src/framework/infrastructure/drizzle';
import { Keyword, InsertKeyword, Metadata } from 'src/licitaapp/domain';
export declare class KeywordRepositoryImpl implements KeywordRepository {
    private readonly db;
    private readonly LOGGER;
    constructor(db: DBConfigService);
    getAllWithouthMetadata(tx?: TxType): Promise<Keyword[]>;
    findByCompanyId(companyId: number, isNullMetadata: boolean, tx?: TxType): Promise<Keyword[]>;
    save(keyword: InsertKeyword, userId: number, tx?: TxType): Promise<Keyword>;
    saveAll(keywords: InsertKeyword[], userId: number, tx?: TxType): Promise<Keyword[]>;
    updateMetadata(keywordId: number, metadata: Metadata): Promise<void>;
    findById(id: number, tx?: TxType): Promise<Keyword | null | undefined>;
    logicalRemove(id: number, tx?: TxType): Promise<void>;
    deleteByCompanyId(companyId: number, tx?: TxType): Promise<void>;
}
