"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var ApplicationLogRepositoryImpl_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLogRepositoryImpl = void 0;
const common_1 = require("@nestjs/common");
const framework_1 = require("../../../../framework");
const domain_1 = require("../../../domain");
const framework_2 = require("../../../../framework");
const util_1 = require("../../../domain/util");
const drizzle_orm_1 = require("drizzle-orm");
let ApplicationLogRepositoryImpl = ApplicationLogRepositoryImpl_1 = class ApplicationLogRepositoryImpl {
    constructor(db) {
        this.db = db;
        this.LOGGER = new framework_1.PrimeLogger(ApplicationLogRepositoryImpl_1.name);
    }
    async save(applicationLog, tx) {
        this.LOGGER.log(`save repository: ${applicationLog}`);
        const validatedApplicationLog = framework_2.schema.applicationLogTableInsertSchema.parse({
            userName: applicationLog.userName,
            statusTypeId: applicationLog.statusTypeId,
            detail: applicationLog.detail,
            type: applicationLog.type
        });
        const insertedApplicationLogId = await (tx || this.db.conn)
            .insert(framework_2.schema.applicationLogTable)
            .values(validatedApplicationLog)
            .$returningId()
            .then((rows) => {
            return rows[0].id;
        });
        return insertedApplicationLogId;
    }
    async updateState(applicationLogId, statusTypeId, detail, tx) {
        this.LOGGER.log(`update applicationLog Id: ${applicationLogId} statusTypeId: ${statusTypeId}`);
        const validatedApplicationLog = framework_2.schema.applicationLogTableUpdateSchema.parse({
            statusTypeId: statusTypeId,
            updatedAt: util_1.TenderUtil.getCurrentSystemDate(),
            detail: detail
        });
        await (tx || this.db.conn)
            .update(framework_2.schema.applicationLogTable)
            .set(validatedApplicationLog)
            .where((0, drizzle_orm_1.eq)(framework_2.schema.applicationLogTable.id, applicationLogId))
            .execute();
        return true;
    }
    async logicalRemove(applicationLogId, tx) {
        this.LOGGER.log(`logicalRemove applicationLog Id: ${applicationLogId}`);
        await (tx || this.db.conn)
            .update(framework_2.schema.applicationLogTable)
            .set({ active: false, deletedAt: util_1.TenderUtil.getCurrentSystemDate() })
            .where((0, drizzle_orm_1.eq)(framework_2.schema.applicationLogTable.id, applicationLogId))
            .execute();
        return true;
    }
    async findAll(page, pageSize, type) {
        const offset = (page - 1) * pageSize;
        this.LOGGER.log(`findAll applicationLog offset: ${offset} page: ${page}, pageSize: ${pageSize}, type: ${type}`);
        const selectFields = {
            id: framework_2.schema.applicationLogTable.id,
            userName: framework_2.schema.applicationLogTable.userName,
            createdAt: framework_2.schema.applicationLogTable.createdAt,
            updatedAt: framework_2.schema.applicationLogTable.updatedAt,
            type: framework_2.schema.applicationLogTable.type,
            detail: framework_2.schema.applicationLogTable.detail,
            statusText: framework_2.schema.typeMasterTable.name,
        };
        const whereSentence = type
            ? (0, drizzle_orm_1.and)((0, drizzle_orm_1.eq)(framework_2.schema.applicationLogTable.active, true), (0, drizzle_orm_1.eq)(framework_2.schema.applicationLogTable.type, type))
            : (0, drizzle_orm_1.eq)(framework_2.schema.applicationLogTable.active, true);
        const query = this.db.conn
            .select(selectFields)
            .from(framework_2.schema.applicationLogTable)
            .innerJoin(framework_2.schema.typeMasterTable, (0, drizzle_orm_1.eq)(framework_2.schema.typeMasterTable.id, framework_2.schema.applicationLogTable.statusTypeId))
            .where(whereSentence)
            .limit(Number(pageSize))
            .offset(offset);
        const rows = await query;
        if (rows.length === 0) {
            return [];
        }
        return rows.map((row) => {
            const appLog = new domain_1.ApplicationLog(row.id, row.userName, 0, row.detail, row.type);
            appLog.createdAt = row.createdAt;
            appLog.updatedAt = row.updatedAt;
            appLog.statusText = row.statusText;
            return appLog;
        });
    }
};
exports.ApplicationLogRepositoryImpl = ApplicationLogRepositoryImpl;
exports.ApplicationLogRepositoryImpl = ApplicationLogRepositoryImpl = ApplicationLogRepositoryImpl_1 = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)((0, common_1.forwardRef)(() => framework_1.DBConfigService))),
    __metadata("design:paramtypes", [framework_1.DBConfigService])
], ApplicationLogRepositoryImpl);
//# sourceMappingURL=application-log-repository-impl.js.map