"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var TendersController_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TendersController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const framework_1 = require("../../../../framework");
const allow_roles_decorator_1 = require("../../../../framework/infrastructure/decorators/allow-profiles/allow-roles.decorator");
const api_default_responses_decorator_1 = require("../../../../framework/infrastructure/decorators/api-default-responses/api-default-responses.decorator");
const prime_user_decorator_1 = require("../../../../framework/infrastructure/decorators/prime-user/prime-user.decorator");
const domain_1 = require("../../../domain");
let TendersController = TendersController_1 = class TendersController {
    constructor(tenderService, companyService) {
        this.tenderService = tenderService;
        this.companyService = companyService;
        this.LOGGER = new framework_1.PrimeLogger(TendersController_1.name);
    }
    async reviewTendersInfo(paramTO) {
        this.LOGGER.log(`init reviewTendersInfo action: ${paramTO}`);
        this.tenderService.reviewTendersInfo(paramTO.action);
        return 'true';
    }
    async createCompany(user, company) {
        this.LOGGER.warn(`Creating company for user: ${user.id}`);
        const newCompany = await this.companyService.createCompany(user.id, company);
        newCompany?.company.id &&
            this.tenderService.createDashboardCompany(newCompany?.company.id, user.id);
        return newCompany;
    }
    async createDashboardCompany(user, companyId) {
        this.LOGGER.log(`init createDashboardCompany companyId: ${companyId} user ${user.id}`);
        this.tenderService.createDashboardCompany(companyId, user.id);
        return 'true';
    }
    async myDashboard(user, companyId) {
        this.LOGGER.log(`MyDashboard - user: ${user.id} companyId: ${companyId}`);
        return this.tenderService.generateInfoDashboard(user, companyId);
    }
    async listHistoryTender(user) {
        this.LOGGER.log(`ListHistoryTender - user: ${user.id}`);
        return await this.tenderService.getListTenderHistory(user.id);
    }
    async getHistoryPaginated(user, page, pageSize) {
        this.LOGGER.log(`GetHistoryPaginated - user: ${user.id}, page: ${page}, pageSize: ${pageSize}`);
        return await this.tenderService.getPaginatedHistoryTenders(user.id, page, pageSize);
    }
    async getPaginatedTenders(user, page, pageSize, companyId, searchType, isFavorite, subdivisionId, monthRequest) {
        this.LOGGER
            .log(`GetPaginatedTenders - user: ${user.id}, page: ${page}, pageSize: ${pageSize}, companyId: ${companyId} searchType: ${searchType} isFavorite: ${isFavorite} 
      subdivisionId: ${subdivisionId} monthRequest: ${monthRequest}`);
        return await this.tenderService.getPaginatedTenders(user.id, companyId, page, pageSize, searchType, subdivisionId, monthRequest);
    }
    async findByCode(user, code) {
        this.LOGGER.log(`FindByCode - code: ${code} user: ${user.id}`);
        return await this.tenderService.getTenderByCode(code, user.id);
    }
    async updateFavoriteUserCompanytender(user, tenderId, companyId, isFavorite) {
        this.LOGGER.log(`Favorite - user: ${user.id}, tenderId: ${tenderId}, isFavorite: ${isFavorite} companyId: ${companyId}`);
        this.tenderService.updateFavoriteUserCompanytender(user.id, companyId, tenderId, isFavorite === 'true');
        return 'true';
    }
    async logicalRemoveCompanyTenderUser(user, companyId, tenderId) {
        this.LOGGER.warn(`delete companyId ${companyId} user ${user.id} tenderId ${tenderId}`);
        await this.tenderService.logicalRemoveCompanyTenderUser(user.id, companyId, tenderId);
        return 'true';
    }
    async addTenderByCodeToCompany(companyId, code) {
        this.LOGGER.warn(`addTenderByCodeToCompany companyId ${companyId} code ${code}`);
        return await this.tenderService.addTenderByCodeToCompany(code, companyId);
    }
};
exports.TendersController = TendersController;
__decorate([
    (0, common_1.Put)('review-tender-info'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, swagger_1.ApiBody)({ type: domain_1.ActionReview }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [domain_1.ActionReview]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "reviewTendersInfo", null);
__decorate([
    (0, common_1.Post)('create-company'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.CompanyFullTO }),
    (0, swagger_1.ApiBody)({ type: domain_1.CompanyRegisterTO }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User,
        domain_1.CompanyRegisterTO]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "createCompany", null);
__decorate([
    (0, common_1.Put)('create-dashboard-company/:companyId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('companyId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "createDashboardCompany", null);
__decorate([
    (0, common_1.Get)('dashboard/:companyId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.DashboardTO }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('companyId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "myDashboard", null);
__decorate([
    (0, common_1.Get)('history-tender'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.HistoryTender] }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "listHistoryTender", null);
__decorate([
    (0, common_1.Get)('history/:page/:pageSize'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.HistoryTenderDetail] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('page')),
    __param(2, (0, common_1.Param)('pageSize')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "getHistoryPaginated", null);
__decorate([
    (0, common_1.Get)(':page/:pageSize/:companyId/:searchType/:isFavorite/:subdivisionId/:monthRequest'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: [domain_1.Tender] }),
    (0, swagger_1.ApiParam)({ name: 'page', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'pageSize', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'searchType', type: 'string' }),
    (0, swagger_1.ApiParam)({ name: 'isFavorite', type: 'boolean' }),
    (0, swagger_1.ApiParam)({ name: 'subdivisionId', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('page')),
    __param(2, (0, common_1.Param)('pageSize')),
    __param(3, (0, common_1.Param)('companyId')),
    __param(4, (0, common_1.Param)('searchType')),
    __param(5, (0, common_1.Param)('isFavorite')),
    __param(6, (0, common_1.Param)('subdivisionId')),
    __param(7, (0, common_1.Param)('monthRequest')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number, Number, String, Boolean, Number, String]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "getPaginatedTenders", null);
__decorate([
    (0, common_1.Get)(':code'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    (0, swagger_1.ApiOkResponse)({ type: domain_1.Tender }),
    (0, swagger_1.ApiParam)({ name: 'code', type: 'string' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('code')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, String]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "findByCode", null);
__decorate([
    (0, common_1.Put)('update-favorite-user-tender/:tenderId/:companyId/:isFavorite'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: () => String }),
    (0, swagger_1.ApiParam)({ name: 'tenderId', type: 'number' }),
    (0, swagger_1.ApiParam)({ name: 'isFavorite', type: 'string' }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('tenderId')),
    __param(2, (0, common_1.Param)('companyId')),
    __param(3, (0, common_1.Param)('isFavorite')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number, String]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "updateFavoriteUserCompanytender", null);
__decorate([
    (0, common_1.Delete)('tender-company-user/:companyId/:tenderId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: String }),
    (0, allow_roles_decorator_1.AllowRoles)(allow_roles_decorator_1.RoleShortNameEnum.USER, allow_roles_decorator_1.RoleShortNameEnum.ADMIN),
    __param(0, (0, prime_user_decorator_1.PrimeUser)()),
    __param(1, (0, common_1.Param)('companyId')),
    __param(2, (0, common_1.Param)('tenderId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [framework_1.User, Number, Number]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "logicalRemoveCompanyTenderUser", null);
__decorate([
    (0, common_1.Put)('add-tender-by-code-to-company/:code/:companyId'),
    (0, api_default_responses_decorator_1.ApiDefaultResponses)(),
    (0, swagger_1.ApiOkResponse)({ type: () => String }),
    (0, swagger_1.ApiParam)({ name: 'code', type: 'string' }),
    (0, swagger_1.ApiParam)({ name: 'companyId', type: 'number' }),
    __param(0, (0, common_1.Param)('companyId')),
    __param(1, (0, common_1.Param)('code')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", Promise)
], TendersController.prototype, "addTenderByCodeToCompany", null);
exports.TendersController = TendersController = TendersController_1 = __decorate([
    (0, swagger_1.ApiTags)('tenders'),
    (0, common_1.Controller)('tenders'),
    __param(0, (0, common_1.Inject)('TenderService')),
    __param(1, (0, common_1.Inject)('CompanyService')),
    __metadata("design:paramtypes", [Object, Object])
], TendersController);
//# sourceMappingURL=tender.controller.js.map