import { User } from 'src/framework';
import { CompanyService, UserCompanyService } from 'src/licitaapp';
import { TenderService } from 'src/licitaapp/application/service/tender-service/tender-service.interface';
import { Company, CompanyFullTO, CompanyRegisterTO } from 'src/licitaapp/domain';
import { CompanyUserTO } from 'src/licitaapp/domain/dto/company.user.to';
export declare class CompanyController {
    private readonly companyService;
    private readonly userCompanyService;
    private readonly tenderService;
    private readonly LOGGER;
    constructor(companyService: CompanyService, userCompanyService: UserCompanyService, tenderService: TenderService);
    companiesByUserId(user: User): Promise<Company[]>;
    activeCheckTender(id: number): Promise<String>;
    update(user: User, id: number, companyData: CompanyRegisterTO): Promise<CompanyFullTO | null>;
    findById(id: number): Promise<CompanyFullTO | null>;
    paginationByUser(user: User, page: number, pageSize: number): Promise<Company[]>;
    findByUserId(user: User): Promise<Company[]>;
    logicalRemove(user: User, companyId: number, userId: number): Promise<String>;
    paginationCompanyAdmin(page: number, pageSize: number): Promise<CompanyUserTO[]>;
}
