"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TenderUtil = void 0;
class TenderUtil {
    static convertToMillions(amount) {
        if (amount >= 1000000) {
            return (Math.floor(amount / 1000000)
                .toString()
                .replace(/\B(?=(\d{3})+(?!\d))/g, '.') + 'M');
        }
        return amount.toString().replace(/\B(?=(\d{3})+(?!\d))/g, '.');
    }
    static calculateTimeFromDateString(endDate) {
        if (!endDate) {
            return '';
        }
        const currentTime = TenderUtil.getCurrentSystemDate();
        const compareDate = new Date(endDate);
        compareDate.toLocaleString('es-CL', { timeZone: 'America/Santiago' });
        const diff = compareDate.getTime() - currentTime.getTime();
        const diffInMinutes = Math.floor(diff / 60000);
        if (diffInMinutes < 0) {
            return 'Finalizado';
        }
        if (diffInMinutes < 60) {
            return diffInMinutes + (diffInMinutes == 1 ? ' minuto' : ' minutos');
        }
        const diffInHours = Math.floor(diff / (1000 * 60 * 60));
        if (diffInHours < 24) {
            return diffInHours + (diffInHours == 1 ? ' hora' : ' horas');
        }
        const diffInDays = Math.floor(diff / (1000 * 60 * 60 * 24));
        return diffInDays + (diffInDays == 1 ? ' día' : ' días');
    }
    static calculateTime(createDate, updateDate) {
        const currentTime = TenderUtil.getCurrentSystemDate();
        const compareDate = updateDate ? updateDate : createDate;
        const diff = currentTime.getTime() - compareDate.getTime();
        const diffInMinutes = Math.floor(diff / 60000);
        if (diffInMinutes < 60) {
            return diffInMinutes + (diffInMinutes == 1 ? ' minuto' : ' minutos');
        }
        const diffInHours = Math.floor(diff / (1000 * 60 * 60));
        if (diffInHours < 24) {
            return diffInHours + (diffInHours == 1 ? ' hora' : ' horas');
        }
        const diffInDays = Math.floor(diff / (1000 * 60 * 60 * 24));
        return diffInDays + (diffInDays == 1 ? ' día' : ' días');
    }
    static getMonthStartAndEnd(date, offsetMonths = 0) {
        const year = date.getFullYear();
        const month = date.getMonth() + offsetMonths;
        const start = new Date(year, month, 1, 0, 0, 0);
        start.toLocaleString('es-CL', { timeZone: 'America/Santiago' });
        const end = new Date(year, month + 1, 0, 23, 59, 59);
        end.toLocaleString('es-CL', { timeZone: 'America/Santiago' });
        return { start, end };
    }
    static subtractDays(date, days) {
        const result = new Date(date);
        result.setDate(result.getDate() - days);
        return result;
    }
    static getDayStartAndEnd(date) {
        const start = new Date(date);
        start.toLocaleString('es-CL', { timeZone: 'America/Santiago' });
        start.setHours(0, 0, 0, 0);
        const end = new Date(date);
        end.toLocaleString('es-CL', { timeZone: 'America/Santiago' });
        end.setHours(23, 59, 59, 999);
        return { start, end };
    }
    static getSystemDateDDMMYYYY() {
        const now = new Date();
        now.toLocaleString('es-CL', { timeZone: 'America/Santiago' });
        return new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0, 0);
    }
    static getCurrentSystemDate() {
        let now = new Date();
        now.toLocaleString('es-CL', { timeZone: 'America/Santiago' });
        return now;
    }
    static evalMonth(description) {
        const meses = {
            enero: 0,
            febrero: 1,
            marzo: 2,
            abril: 3,
            mayo: 4,
            junio: 5,
            julio: 6,
            agosto: 7,
            septiembre: 8,
            octubre: 9,
            noviembre: 10,
            diciembre: 11,
        };
        const regex = new RegExp(`(enero|febrero|marzo|abril|mayo|junio|julio|agosto|septiembre|octubre|noviembre|diciembre)\\s+(\\d{4})`, 'i');
        const match = description.match(regex);
        if (!match) {
            return null;
        }
        const mes = match[1].toLowerCase();
        const año = parseInt(match[2], 10);
        return new Date(año, meses[mes], 1);
    }
}
exports.TenderUtil = TenderUtil;
TenderUtil.TIMEZONE = 'America/Santiago';
//# sourceMappingURL=tender.util.js.map