"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OrdenesDeCompraResponse = exports.OrdenesDeCompraQueryParamsSchema = void 0;
const zod_1 = require("zod");
var EstadoQueryEnum;
(function (EstadoQueryEnum) {
    EstadoQueryEnum["ENVIADA_A_PROVEEDOR"] = "enviadaproveedor";
    EstadoQueryEnum["ACEPTADA"] = "aceptada";
    EstadoQueryEnum["CANCELADA"] = "cancelada";
    EstadoQueryEnum["RECEPCION_CONFORME"] = "recepcionconforme";
    EstadoQueryEnum["PENDIENTE_RECEPCION"] = "pendienterecepcion";
    EstadoQueryEnum["RECEPCION_PARCIAL"] = "recepcionparcial";
    EstadoQueryEnum["RECEPCION_CONFORME_INCOMPLETA"] = "recepcionconformeincompleta";
    EstadoQueryEnum["TODOS"] = "todos";
})(EstadoQueryEnum || (EstadoQueryEnum = {}));
var TipoOrdenEnum;
(function (TipoOrdenEnum) {
    TipoOrdenEnum["SE"] = "SE";
    TipoOrdenEnum["CM"] = "CM";
})(TipoOrdenEnum || (TipoOrdenEnum = {}));
var TipoMonedaEnum;
(function (TipoMonedaEnum) {
    TipoMonedaEnum["CLP"] = "CLP";
    TipoMonedaEnum["CLF"] = "CLF";
    TipoMonedaEnum["USD"] = "USD";
    TipoMonedaEnum["UTM"] = "UTM";
    TipoMonedaEnum["EUR"] = "EUR";
})(TipoMonedaEnum || (TipoMonedaEnum = {}));
var TipoDespachoEnum;
(function (TipoDespachoEnum) {
    TipoDespachoEnum[TipoDespachoEnum["DIRECCION_ENVIO"] = 7] = "DIRECCION_ENVIO";
    TipoDespachoEnum[TipoDespachoEnum["PROGRAMA_ADJUNTADO"] = 9] = "PROGRAMA_ADJUNTADO";
    TipoDespachoEnum[TipoDespachoEnum["OTRA_FORMA"] = 12] = "OTRA_FORMA";
    TipoDespachoEnum[TipoDespachoEnum["RETIRAMOS_BODEGA"] = 14] = "RETIRAMOS_BODEGA";
    TipoDespachoEnum[TipoDespachoEnum["COURIER_AEREO"] = 20] = "COURIER_AEREO";
    TipoDespachoEnum[TipoDespachoEnum["COURIER_TERRESTRE"] = 21] = "COURIER_TERRESTRE";
    TipoDespachoEnum[TipoDespachoEnum["A_CONVENIR"] = 22] = "A_CONVENIR";
})(TipoDespachoEnum || (TipoDespachoEnum = {}));
var FormaPagoEnum;
(function (FormaPagoEnum) {
    FormaPagoEnum[FormaPagoEnum["QUINCE_DIAS"] = 1] = "QUINCE_DIAS";
    FormaPagoEnum[FormaPagoEnum["TREINTA_DIAS"] = 2] = "TREINTA_DIAS";
    FormaPagoEnum[FormaPagoEnum["OTRA_FORMA"] = 39] = "OTRA_FORMA";
    FormaPagoEnum[FormaPagoEnum["CINCUENTA_DIAS"] = 46] = "CINCUENTA_DIAS";
    FormaPagoEnum[FormaPagoEnum["SESENTA_DIAS"] = 47] = "SESENTA_DIAS";
})(FormaPagoEnum || (FormaPagoEnum = {}));
class OrdenesDeCompraResponse {
    static fromJson(data) {
        data.Listado = data.Listado.map((item) => {
            item.TieneItems = item.TieneItems === '1';
            return item;
        });
        return data;
    }
}
exports.OrdenesDeCompraResponse = OrdenesDeCompraResponse;
const OrdenesDeCompraQueryParamsSchema = zod_1.z
    .object({
    codigo: zod_1.z.string().optional(),
    fecha: zod_1.z.string().optional(),
    estado: zod_1.z.nativeEnum(EstadoQueryEnum).optional(),
    CodigoOrganismo: zod_1.z.string().optional(),
    CodigoProveedor: zod_1.z.string().optional(),
})
    .refine((data) => {
    const keys = [
        'codigo',
        'fecha',
        'estado',
        'CodigoOrganismo',
        'CodigoProveedor',
    ];
    const providedKeys = keys.filter((key) => data[key] !== undefined);
    return providedKeys.length === 1;
}, {
    message: 'Only one filter can be used at a time.',
    path: [],
});
exports.OrdenesDeCompraQueryParamsSchema = OrdenesDeCompraQueryParamsSchema;
//# sourceMappingURL=mp.ordenes-compra.types.js.map