"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LicitacionesResponse = exports.LicitacionesQueryParamsSchema = void 0;
const zod_1 = require("zod");
var AdjudicacionTipoEnum;
(function (AdjudicacionTipoEnum) {
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["AUTORIZACION"] = 1] = "AUTORIZACION";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["RESOLUCION"] = 2] = "RESOLUCION";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["ACUERDO"] = 3] = "ACUERDO";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["DECRETO"] = 4] = "DECRETO";
    AdjudicacionTipoEnum[AdjudicacionTipoEnum["OTROS"] = 5] = "OTROS";
})(AdjudicacionTipoEnum || (AdjudicacionTipoEnum = {}));
var MonedaEnum;
(function (MonedaEnum) {
    MonedaEnum["CLP"] = "CLP";
    MonedaEnum["CLF"] = "CLF";
    MonedaEnum["USD"] = "USD";
    MonedaEnum["UTM"] = "UTM";
    MonedaEnum["EUR"] = "EUR";
})(MonedaEnum || (MonedaEnum = {}));
var JustificacionMontoEstimadoEnum;
(function (JustificacionMontoEstimadoEnum) {
    JustificacionMontoEstimadoEnum[JustificacionMontoEstimadoEnum["PRESPUEST_DISPONIBLE"] = 1] = "PRESPUEST_DISPONIBLE";
    JustificacionMontoEstimadoEnum[JustificacionMontoEstimadoEnum["PRECIO_REFERENCIAL"] = 2] = "PRECIO_REFERENCIAL";
    JustificacionMontoEstimadoEnum[JustificacionMontoEstimadoEnum["MONTO_NO_ESTIMABLE"] = 3] = "MONTO_NO_ESTIMABLE";
})(JustificacionMontoEstimadoEnum || (JustificacionMontoEstimadoEnum = {}));
var ModalidadPagoEnum;
(function (ModalidadPagoEnum) {
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_30_DIAS"] = 1] = "PAGO_30_DIAS";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_30_60_90_DIAS"] = 2] = "PAGO_30_60_90_DIAS";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_AL_DIA"] = 3] = "PAGO_AL_DIA";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_ANUAL"] = 4] = "PAGO_ANUAL";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_BIMENSUAL"] = 5] = "PAGO_BIMENSUAL";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_CONTRA_ENTREGA_CONFORME"] = 6] = "PAGO_CONTRA_ENTREGA_CONFORME";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGOS_MENSUALES"] = 7] = "PAGOS_MENSUALES";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_POR_ESTADO_DE_AVANCE"] = 8] = "PAGO_POR_ESTADO_DE_AVANCE";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_TRIMESTRAL"] = 9] = "PAGO_TRIMESTRAL";
    ModalidadPagoEnum[ModalidadPagoEnum["PAGO_60_DIAS"] = 10] = "PAGO_60_DIAS";
})(ModalidadPagoEnum || (ModalidadPagoEnum = {}));
var UnidadTiempoEnum;
(function (UnidadTiempoEnum) {
    UnidadTiempoEnum[UnidadTiempoEnum["HORAS"] = 1] = "HORAS";
    UnidadTiempoEnum[UnidadTiempoEnum["DIAS"] = 2] = "DIAS";
    UnidadTiempoEnum[UnidadTiempoEnum["SEMANAS"] = 3] = "SEMANAS";
    UnidadTiempoEnum[UnidadTiempoEnum["MESES"] = 4] = "MESES";
    UnidadTiempoEnum[UnidadTiempoEnum["ANOS"] = 5] = "ANOS";
})(UnidadTiempoEnum || (UnidadTiempoEnum = {}));
var TipoEnum;
(function (TipoEnum) {
    TipoEnum["L1"] = "L1";
    TipoEnum["LE"] = "LE";
    TipoEnum["LP"] = "LP";
    TipoEnum["LQ"] = "LQ";
    TipoEnum["LR"] = "LR";
    TipoEnum["E2"] = "E2";
    TipoEnum["CO"] = "CO";
    TipoEnum["B2"] = "B2";
    TipoEnum["H2"] = "H2";
    TipoEnum["I2"] = "I2";
    TipoEnum["LS"] = "LS";
})(TipoEnum || (TipoEnum = {}));
class LicitacionesResponse {
    static fromJson(data) {
        data.Listado = data.Listado.map((item) => {
            item.Informada = item.Informada === 1;
            item.VisibilidadMonto =
                item.VisibilidadMonto === 1;
            item.SubContratacion = item.SubContratacion === 1;
            item.ExtensionPlazo = item.ExtensionPlazo === 1;
            item.EsBaseTipo = item.EsBaseTipo === 1;
            item.EsRenovable = item.EsRenovable === 1;
            return item;
        });
        return data;
    }
}
exports.LicitacionesResponse = LicitacionesResponse;
var EstadoQueryEnum;
(function (EstadoQueryEnum) {
    EstadoQueryEnum["PUBLICADA"] = "Publicada";
    EstadoQueryEnum["CERRADA"] = "Cerrada";
    EstadoQueryEnum["DESIERTA"] = "Desierta";
    EstadoQueryEnum["ADJUDICADA"] = "Adjudicada";
    EstadoQueryEnum["REVOCADA"] = "Revocada";
    EstadoQueryEnum["SUSPENDIDA"] = "Suspendida";
    EstadoQueryEnum["ACTIVAS"] = "activas";
})(EstadoQueryEnum || (EstadoQueryEnum = {}));
const LicitacionesQueryParamsSchema = zod_1.z
    .object({
    codigo: zod_1.z.string().optional(),
    fecha: zod_1.z.string().optional(),
    estado: zod_1.z.nativeEnum(EstadoQueryEnum).optional(),
    CodigoOrganismo: zod_1.z.string().optional(),
    CodigoProveedor: zod_1.z.string().optional(),
})
    .refine((data) => {
    const keys = [
        'codigo',
        'fecha',
        'estado',
        'CodigoOrganismo',
        'CodigoProveedor',
    ];
    const providedKeys = keys.filter((key) => data[key] !== undefined);
    return providedKeys.length === 1;
}, {
    message: 'Only one filter can be used at a time.',
    path: [],
});
exports.LicitacionesQueryParamsSchema = LicitacionesQueryParamsSchema;
//# sourceMappingURL=mp.licitaciones.types.js.map